"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.removeDocument = exports.getCurationsBreadcrumbs = exports.convertToDate = exports.addDocument = void 0;
var _engine = require("../engine");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCurationsBreadcrumbs = (breadcrumbs = []) => (0, _engine.getEngineBreadcrumbs)([_constants.CURATIONS_TITLE, ...breadcrumbs]);

// The server API feels us an English datestring, but we want to convert
// it to an actual Date() instance so that we can localize date formats.
exports.getCurationsBreadcrumbs = getCurationsBreadcrumbs;
const convertToDate = serverDateString => {
  const readableDateString = serverDateString.replace(' at ', ' ').replace('PM', ' PM').replace('AM', ' AM');
  return new Date(readableDateString);
};
exports.convertToDate = convertToDate;
const addDocument = (documentArray, newDocument) => {
  return [...documentArray, newDocument];
};
exports.addDocument = addDocument;
const removeDocument = (documentArray, deletedDocument) => {
  const newArray = [...documentArray];
  const indexToDelete = newArray.indexOf(deletedDocument);
  newArray.splice(indexToDelete, 1);
  return newArray;
};
exports.removeDocument = removeDocument;