"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getModeDisplayText = void 0;
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getModeDisplayText = apiToken => {
  const {
    read = false,
    write = false,
    type
  } = apiToken;
  switch (type) {
    case _constants.ApiTokenTypes.Admin:
      return '--';
    case _constants.ApiTokenTypes.Search:
      return _constants.SEARCH_DISPLAY;
    default:
      if (read && write) {
        return _constants.READ_WRITE;
      }
      return write ? _constants.WRITE_ONLY : _constants.READ_ONLY;
  }
};
exports.getModeDisplayText = getModeDisplayText;