"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Key = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Key = ({
  copy,
  toggleIsHidden,
  isHidden,
  text
}) => {
  const hideIcon = isHidden ? 'eye' : 'eyeClosed';
  const hideIconLabel = isHidden ? _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.credentials.showApiKey', {
    defaultMessage: 'Show API Key'
  }) : _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.credentials.hideApiKey', {
    defaultMessage: 'Hide API Key'
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: copy,
    iconType: "copyClipboard",
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.credentials.copyApiKey', {
      defaultMessage: 'Copy API Key to clipboard'
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: toggleIsHidden,
    iconType: hideIcon,
    "aria-label": hideIconLabel,
    "aria-pressed": !isHidden,
    style: {
      marginRight: '0.25em'
    }
  }), text);
};
exports.Key = Key;