"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CrawlerStatusBanner = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _crawler_logic = require("../crawler_logic");
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CrawlerStatusBanner = () => {
  const {
    mostRecentCrawlRequestStatus
  } = (0, _kea.useValues)(_crawler_logic.CrawlerLogic);
  if (mostRecentCrawlRequestStatus === _types.CrawlerStatus.Running || mostRecentCrawlRequestStatus === _types.CrawlerStatus.Starting || mostRecentCrawlRequestStatus === _types.CrawlerStatus.Canceling) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      iconType: "iInCircle",
      title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlerStatusBanner.changesCalloutTitle', {
        defaultMessage: "Changes you make now won't take effect until the start of your next crawl."
      })
    });
  }
  return null;
};
exports.CrawlerStatusBanner = CrawlerStatusBanner;