"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDomainWithProtocol = exports.extractDomainAndEntryPointFromUrl = exports.domainValidationStateToPanelColor = exports.domainValidationFailureResultChange = void 0;
var _i18n = require("@kbn/i18n");
var _http = require("../../../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const extractDomainAndEntryPointFromUrl = url => {
  let domain = url;
  let entryPoint = '/';
  const pathSlashIndex = url.search(/[^\:\/]\//);
  if (pathSlashIndex !== -1) {
    domain = url.substring(0, pathSlashIndex + 1);
    entryPoint = url.substring(pathSlashIndex + 1);
  }
  return {
    domain,
    entryPoint
  };
};
exports.extractDomainAndEntryPointFromUrl = extractDomainAndEntryPointFromUrl;
const getDomainWithProtocol = async domain => {
  const {
    http
  } = _http.HttpLogic.values;
  if (!domain.startsWith('https://') && !domain.startsWith('http://')) {
    try {
      const route = '/internal/app_search/crawler/validate_url';
      const checks = ['tcp', 'url_request'];
      const httpsCheckData = await http.post(route, {
        body: JSON.stringify({
          url: `https://${domain}`,
          checks
        })
      });
      if (httpsCheckData.valid) {
        return `https://${domain}`;
      }
      const httpCheckData = await http.post(route, {
        body: JSON.stringify({
          url: `http://${domain}`,
          checks
        })
      });
      if (httpCheckData.valid) {
        return `http://${domain}`;
      }
      // eslint-disable-next-line @typescript-eslint/no-unused-vars
    } catch (error) {
      // Do nothing as later validation steps will catch errors
    }
  }
  return domain;
};
exports.getDomainWithProtocol = getDomainWithProtocol;
const domainValidationStateToPanelColor = state => {
  switch (state) {
    case 'valid':
      return 'success';
    case 'warning':
      return 'warning';
    case 'invalid':
      return 'danger';
    default:
      return 'subdued';
  }
};
exports.domainValidationStateToPanelColor = domainValidationStateToPanelColor;
const allFailureResultChanges = {
  networkConnectivity: {
    state: 'invalid',
    message: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.addDomainForm.networkConnectivityFailureMessage', {
      defaultMessage: 'Unable to establish a network connection because the "Initial validation" check failed.'
    })
  },
  indexingRestrictions: {
    state: 'invalid',
    message: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.addDomainForm.indexingRestrictionsFailureMessage', {
      defaultMessage: 'Unable to determine indexing restrictions because the "Network connectivity" check failed.'
    })
  },
  contentVerification: {
    state: 'invalid',
    message: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.addDomainForm.contentVerificationFailureMessage', {
      defaultMessage: 'Unable to verify content because the "Indexing restrictions" check failed.'
    })
  }
};
const domainValidationFailureResultChange = stepName => {
  switch (stepName) {
    case 'initialValidation':
      return allFailureResultChanges;
    case 'networkConnectivity':
      return {
        indexingRestrictions: allFailureResultChanges.indexingRestrictions,
        contentVerification: allFailureResultChanges.contentVerification
      };
    case 'indexingRestrictions':
      return {
        contentVerification: allFailureResultChanges.contentVerification
      };
    default:
      return {};
  }
};
exports.domainValidationFailureResultChange = domainValidationFailureResultChange;