"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGraphsFromNames = void 0;
var _graphs = require("../../../lib/langchain/graphs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getGraphsFromNames = graphNames => graphNames.reduce((acc, graphName) => {
  const graph = _graphs.ASSISTANT_GRAPH_MAP[graphName];
  if (graph != null) {
    return graph.graphType === 'assistant' ? {
      ...acc,
      assistantGraphs: [...acc.assistantGraphs, graph]
    } : {
      ...acc,
      attackDiscoveryGraphs: [...acc.attackDiscoveryGraphs, graph]
    };
  }
  return acc;
}, {
  attackDiscoveryGraphs: [],
  assistantGraphs: []
});
exports.getGraphsFromNames = getGraphsFromNames;