"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withAssistantSpan = void 0;
var _apmUtils = require("@kbn/apm-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This is a thin wrapper around withSpan from @kbn/apm-utils, which sets
 * span type to 'elasticAssistant' by default. This span type is used to
 * distinguish assistant spans from everything else when inspecting traces.
 *
 * Use this method to capture information about the execution of a specific
 * code path and highlight it in APM UI.
 *
 * @param optionsOrName Span name or span options object
 * @param cb Code block you want to measure
 *
 * @returns Whatever the measured code block returns
 */
const withAssistantSpan = (optionsOrName, cb) => (0, _apmUtils.withSpan)({
  type: 'elasticAssistant',
  ...(typeof optionsOrName === 'string' ? {
    name: optionsOrName
  } : optionsOrName)
}, cb);
exports.withAssistantSpan = withAssistantSpan;