"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stepRouter = stepRouter;
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * We use a single router endpoint for common conditional edges.
 * This allows for much easier extension later, where one node might want to go back and validate with an earlier node
 * or to a new node that's been added to the graph.
 * More routers could always be added later when needed.
 */
function stepRouter(state) {
  switch (state.lastNode) {
    case _constants.NodeType.AGENT:
      if (state.agentOutcome && 'returnValues' in state.agentOutcome) {
        return state.hasRespondStep ? _constants.NodeType.RESPOND : _constants.NodeType.END;
      }
      return _constants.NodeType.TOOLS;
    case _constants.NodeType.MODEL_INPUT:
      return state.conversationId ? _constants.NodeType.GET_PERSISTED_CONVERSATION : _constants.NodeType.AGENT;
    default:
      return _constants.NodeType.END;
  }
}