"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformSuccessfulGenerationsSearchResult = void 0;
var _get_successfull_generations_search_result = require("../../get_successfull_generations_search_result");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// a map of connector IDs to their successful generations metadata

const transformSuccessfulGenerationsSearchResult = ({
  logger,
  rawResponse
}) => {
  try {
    // Validate the raw response against the schema
    const parsed = _get_successfull_generations_search_result.GetSuccessfulGenerationsSearchResult.parse(rawResponse);

    // Transform the parsed response into the expected format
    return parsed.aggregations.successfull_generations_by_connector_id.buckets.reduce((acc, bucket) => {
      var _bucket$avg_event_dur;
      const connectorId = bucket.key;
      const successfulGenerations = bucket.successful_generations.value;
      const averageSuccessfulDurationNanoseconds = (_bucket$avg_event_dur = bucket.avg_event_duration_nanoseconds.value) !== null && _bucket$avg_event_dur !== void 0 ? _bucket$avg_event_dur : undefined;
      return {
        ...acc,
        [connectorId]: {
          averageSuccessfulDurationNanoseconds,
          successfulGenerations
        }
      };
    }, {});
  } catch (e) {
    const errorMessage = `Failed to parse search results in transformSuccessfulGenerationsSearchResult ${JSON.stringify(e.errors, null, 2)}`;
    logger.error(errorMessage);
    throw new Error(errorMessage);
  }
};
exports.transformSuccessfulGenerationsSearchResult = transformSuccessfulGenerationsSearchResult;