"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEvaluatorLlm = void 0;
var _langsmith = require("@kbn/langchain/server/tracers/langsmith");
var _server = require("@kbn/langchain/server");
var _utils = require("../../../../../routes/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getEvaluatorLlm = async ({
  actionsClient,
  connectorTimeout,
  evaluatorConnectorId,
  experimentConnector,
  langSmithApiKey,
  logger
}) => {
  var _await$actionsClient$;
  const evaluatorConnector = (_await$actionsClient$ = await actionsClient.get({
    id: evaluatorConnectorId !== null && evaluatorConnectorId !== void 0 ? evaluatorConnectorId : experimentConnector.id,
    // fallback to the experiment connector if the evaluator connector is not found:
    throwIfSystemAction: false
  })) !== null && _await$actionsClient$ !== void 0 ? _await$actionsClient$ : experimentConnector;
  const evaluatorLlmType = (0, _utils.getLlmType)(evaluatorConnector.actionTypeId);
  const experimentLlmType = (0, _utils.getLlmType)(experimentConnector.actionTypeId);
  logger.info(`The ${evaluatorConnector.name} (${evaluatorLlmType}) connector will judge output from the ${experimentConnector.name} (${experimentLlmType}) connector`);
  const traceOptions = {
    projectName: 'evaluators',
    tracers: [...(0, _langsmith.getLangSmithTracer)({
      apiKey: langSmithApiKey,
      projectName: 'evaluators',
      logger
    })]
  };
  return new _server.ActionsClientLlm({
    actionsClient,
    connectorId: evaluatorConnector.id,
    llmType: evaluatorLlmType,
    logger,
    temperature: 0,
    // zero temperature for evaluation
    timeout: connectorTimeout,
    traceOptions,
    telemetryMetadata: {
      pluginId: 'security_attack_discovery'
    }
  });
};
exports.getEvaluatorLlm = getEvaluatorLlm;