"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecurityAlertsPageReference = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _popover_reference = require("./popover_reference");
var _translations = require("./translations");
var _use_navigate_to_alerts_page_with_filters = require("../../../../hooks/navigate_to_alerts_page_with_filters/use_navigate_to_alerts_page_with_filters");
var _navigation_helpers = require("./navigation_helpers");
var _typed_kibana_context = require("../../../../context/typed_kibana_context/typed_kibana_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SecurityAlertsPageReference = ({
  contentReferenceNode
}) => {
  const openAlertsPageWithFilters = (0, _use_navigate_to_alerts_page_with_filters.useNavigateToAlertsPageWithFilters)();
  const {
    assistantAvailability
  } = (0, _elasticAssistant.useAssistantContext)();
  const {
    navigateToApp
  } = (0, _typed_kibana_context.useKibana)().services.application;
  const onClick = (0, _react.useCallback)(e => {
    e.preventDefault();
    return (0, _navigation_helpers.openAlertsPageByOpenAndAck)(navigateToApp, openAlertsPageWithFilters, assistantAvailability.hasSearchAILakeConfigurations);
  }, [assistantAvailability.hasSearchAILakeConfigurations, navigateToApp, openAlertsPageWithFilters]);
  return /*#__PURE__*/_react.default.createElement(_popover_reference.PopoverReference, {
    contentReferenceCount: contentReferenceNode.contentReferenceCount,
    "data-test-subj": "SecurityAlertsPageReference"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: onClick,
    "data-test-subj": "alertsReferenceLink"
  }, _translations.SECURITY_ALERTS_PAGE_REFERENCE_LABEL));
};
exports.SecurityAlertsPageReference = SecurityAlertsPageReference;