"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProductDocumentationReference = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _popover_reference = require("./popover_reference");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ProductDocumentationReference = ({
  contentReferenceNode
}) => {
  return /*#__PURE__*/_react.default.createElement(_popover_reference.PopoverReference, {
    contentReferenceCount: contentReferenceNode.contentReferenceCount,
    "data-test-subj": "ProductDocumentationReference"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: contentReferenceNode.contentReference.url,
    target: "_blank"
  }, contentReferenceNode.contentReference.title));
};
exports.ProductDocumentationReference = ProductDocumentationReference;