"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAppTarget = getAppTarget;
exports.initializeEditApi = initializeEditApi;
var _i18n = require("@kbn/i18n");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _get_discover_locator_params = require("./utils/get_discover_locator_params");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function getAppTarget(partialApi, discoverServices) {
  var _dataViews$;
  const savedObjectId = partialApi.savedObjectId$.getValue();
  const dataViews = partialApi.dataViews$.getValue();
  const locatorParams = (0, _get_discover_locator_params.getDiscoverLocatorParams)(partialApi);

  // We need to use a redirect URL if this is a by value saved search using
  // an ad hoc data view to ensure the data view spec gets encoded in the URL
  const useRedirect = !savedObjectId && !(dataViews !== null && dataViews !== void 0 && (_dataViews$ = dataViews[0]) !== null && _dataViews$ !== void 0 && _dataViews$.isPersisted());
  const urlWithoutLocationState = await discoverServices.locator.getUrl({});
  const editUrl = useRedirect ? discoverServices.locator.getRedirectUrl(locatorParams) : await discoverServices.locator.getUrl(locatorParams);
  const editPath = discoverServices.core.http.basePath.remove(editUrl);
  const editApp = useRedirect ? 'r' : 'discover';
  return {
    path: editPath,
    app: editApp,
    editUrl,
    urlWithoutLocationState
  };
}
function initializeEditApi({
  uuid,
  parentApi,
  partialApi,
  isEditable,
  discoverServices
}) {
  /**
   * If the parent is providing context, then the embeddable state transfer service can be used
   * and editing should be allowed; otherwise, do not provide editing capabilities
   */
  if (!parentApi || !(0, _presentationPublishing.apiHasAppContext)(parentApi)) {
    return {};
  }
  const parentApiContext = parentApi.getAppContext();
  return {
    getTypeDisplayName: () => _i18n.i18n.translate('discover.embeddable.search.displayName', {
      defaultMessage: 'Discover session'
    }),
    onEdit: async () => {
      var _partialApi$fetchCont, _parentApiContext$get;
      const appTarget = await getAppTarget(partialApi, discoverServices);
      const stateTransfer = discoverServices.embeddable.getStateTransfer();
      await stateTransfer.navigateToEditor(appTarget.app, {
        path: appTarget.path,
        state: {
          embeddableId: uuid,
          valueInput: partialApi.savedSearch$.getValue(),
          originatingApp: parentApiContext.currentAppId,
          searchSessionId: (_partialApi$fetchCont = partialApi.fetchContext$.getValue()) === null || _partialApi$fetchCont === void 0 ? void 0 : _partialApi$fetchCont.searchSessionId,
          originatingPath: (_parentApiContext$get = parentApiContext.getCurrentPath) === null || _parentApiContext$get === void 0 ? void 0 : _parentApiContext$get.call(parentApiContext)
        }
      });
    },
    isEditingEnabled: isEditable,
    getEditHref: async () => {
      var _await$getAppTarget;
      return (_await$getAppTarget = await getAppTarget(partialApi, discoverServices)) === null || _await$getAppTarget === void 0 ? void 0 : _await$getAppTarget.path;
    }
  };
}