"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRootProfile = exports.BaseAppWrapper = void 0;
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _use_discover_services = require("../../hooks/use_discover_services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * The root profile state
 */

/**
 * Hook to trigger and wait for root profile resolution
 * @param options Options object
 * @returns The root profile state
 */
const useRootProfile = () => {
  const {
    profilesManager,
    core
  } = (0, _use_discover_services.useDiscoverServices)();
  const [rootProfileState, setRootProfileState] = (0, _react.useState)({
    rootProfileLoading: true
  });
  (0, _react.useEffect)(() => {
    const subscription = core.chrome.getActiveSolutionNavId$().pipe((0, _rxjs.distinctUntilChanged)(), (0, _rxjs.filter)(id => id !== undefined), (0, _rxjs.tap)(() => setRootProfileState({
      rootProfileLoading: true
    })), (0, _rxjs.switchMap)(solutionNavId => profilesManager.resolveRootProfile({
      solutionNavId
    })), (0, _rxjs.tap)(({
      getRenderAppWrapper,
      getDefaultAdHocDataViews
    }) => {
      var _getRenderAppWrapper, _getDefaultAdHocDataV;
      return setRootProfileState({
        rootProfileLoading: false,
        AppWrapper: (_getRenderAppWrapper = getRenderAppWrapper === null || getRenderAppWrapper === void 0 ? void 0 : getRenderAppWrapper(BaseAppWrapper)) !== null && _getRenderAppWrapper !== void 0 ? _getRenderAppWrapper : BaseAppWrapper,
        getDefaultAdHocDataViews: (_getDefaultAdHocDataV = getDefaultAdHocDataViews === null || getDefaultAdHocDataViews === void 0 ? void 0 : getDefaultAdHocDataViews(baseGetDefaultAdHocDataViews)) !== null && _getDefaultAdHocDataV !== void 0 ? _getDefaultAdHocDataV : baseGetDefaultAdHocDataViews
      });
    })).subscribe();
    return () => {
      subscription.unsubscribe();
    };
  }, [core.chrome, profilesManager]);
  return rootProfileState;
};
exports.useRootProfile = useRootProfile;
const BaseAppWrapper = ({
  children
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
exports.BaseAppWrapper = BaseAppWrapper;
const baseGetDefaultAdHocDataViews = () => [];