"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDiscoverStateContainer = void 0;
var _react = require("react");
var _discover_state = require("../state_management/discover_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Creates a state container using the initial params and allows to reset it.
 * The container is recreated only when reset is called. This is useful to reset Discover to its initial state.
 * @param params
 */
const useDiscoverStateContainer = params => {
  const [stateContainer, setStateContainer] = (0, _react.useState)(() => (0, _discover_state.getDiscoverStateContainer)(params));
  return [stateContainer, {
    reset: () => {
      setStateContainer((0, _discover_state.getDiscoverStateContainer)(params));
    }
  }];
};
exports.useDiscoverStateContainer = useDiscoverStateContainer;