"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  useContextualGridCustomisations: true
};
exports.useContextualGridCustomisations = void 0;
var _react = require("react");
var _customizations = require("../../../../customizations");
var _logs = require("./logs");
Object.keys(_logs).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _logs[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _logs[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const useContextualGridCustomisations = params => {
  var _useDiscoverCustomiza;
  // TODO / NOTE: This will eventually rely on Discover's context resolution to determine which fields
  // are returned based on the data type.
  const isLogsContext = (_useDiscoverCustomiza = (0, _customizations.useDiscoverCustomization)('data_table')) === null || _useDiscoverCustomiza === void 0 ? void 0 : _useDiscoverCustomiza.logsEnabled;
  const virtualColumnsConfiguration = (0, _react.useMemo)(() => {
    if (!isLogsContext) return null;
    return (0, _logs.getDataGridColumnsConfiguration)(params);
  }, [isLogsContext, params]);
  return virtualColumnsConfiguration;
};
exports.useContextualGridCustomisations = useContextualGridCustomisations;