"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uiSettings = void 0;
var _configSchema = require("@kbn/config-schema");
var _i18n = require("@kbn/i18n");
var _constants = require("../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * uiSettings definitions for Dev Tools
 */
const uiSettings = exports.uiSettings = {
  [_constants.ENABLE_PERSISTENT_CONSOLE_UI_SETTING_ID]: {
    category: [_constants.DEV_TOOLS_FEATURE_ID],
    description: _i18n.i18n.translate('devTools.uiSettings.persistentConsole.description', {
      defaultMessage: 'Enables a persistent console in the Kibana UI. This setting does not affect the standard Console in Dev Tools.'
    }),
    name: _i18n.i18n.translate('devTools.uiSettings.persistentConsole.name', {
      defaultMessage: 'Persistent Console'
    }),
    requiresPageReload: true,
    schema: _configSchema.schema.boolean(),
    value: true
  }
};