"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocTitleService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _texts = require("../constants/texts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class DocTitleService {
  constructor() {
    (0, _defineProperty2.default)(this, "changeDocTitleHandler", () => {});
  }
  setup(_changeDocTitleHandler) {
    this.changeDocTitleHandler = _changeDocTitleHandler;
  }
  setTitle(page) {
    if (!this.changeDocTitleHandler) {
      throw new Error('DocTitle service has not been initialized');
    }
    if (!page || page === 'home') {
      this.changeDocTitleHandler(_texts.i18Texts.breadcrumbs.home);
    } else {
      this.changeDocTitleHandler(`${page} - ${_texts.i18Texts.breadcrumbs.home}`);
    }
  }
}
exports.DocTitleService = DocTitleService;