"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataStreamMapping = getDataStreamMapping;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getDataStreamMapping({
  field,
  datasetQualityESClient,
  dataStream,
  lastBackingIndex
}) {
  var _mappings$lastBacking, _mappings$lastBacking2;
  const mappings = await datasetQualityESClient.mappings({
    index: dataStream
  });
  const properties = (_mappings$lastBacking = mappings[lastBackingIndex]) === null || _mappings$lastBacking === void 0 ? void 0 : (_mappings$lastBacking2 = _mappings$lastBacking.mappings) === null || _mappings$lastBacking2 === void 0 ? void 0 : _mappings$lastBacking2.properties;
  const {
    count: fieldCount,
    capturedMapping: mapping
  } = countFields(properties !== null && properties !== void 0 ? properties : {}, field);
  const fieldPresent = mapping !== undefined;
  const fieldMapping = fieldPresent ? {
    type: mapping === null || mapping === void 0 ? void 0 : mapping.type,
    ignore_above: mapping === null || mapping === void 0 ? void 0 : mapping.ignore_above
  } : undefined;
  return {
    fieldCount,
    fieldPresent,
    fieldMapping
  };
}
function isNestedProperty(property) {
  return 'properties' in property && property.properties !== undefined;
}
function isNestedField(property) {
  return 'fields' in property && property.fields !== undefined;
}
function countFields(mappings, captureField, prefix = '') {
  let fieldCount = 0;
  let capturedMapping;
  for (const field in mappings) {
    if (Object.prototype.hasOwnProperty.call(mappings, field)) {
      const mappingField = mappings[field];
      const currentPath = [prefix, field].filter(Boolean).join('.');

      // Capture the value if the current path matches the captureField
      if (captureField && currentPath === captureField) {
        capturedMapping = mappingField;
      }
      fieldCount++; // Count the current field

      // If there are properties, recursively count nested fields
      if (isNestedProperty(mappingField)) {
        const {
          count,
          capturedMapping: nestedCapturedValue
        } = countFields(mappingField.properties, captureField, currentPath);
        fieldCount += count;
        if (nestedCapturedValue !== undefined) {
          capturedMapping = nestedCapturedValue;
        }
      }

      // If there are fields, recursively count nested fields
      if (isNestedField(mappingField)) {
        const {
          count,
          capturedMapping: nestedCapturedValue
        } = countFields(mappingField.fields, captureField, currentPath);
        fieldCount += count;
        if (nestedCapturedValue !== undefined) {
          capturedMapping = nestedCapturedValue;
        }
      }
    }
  }
  return {
    count: fieldCount,
    capturedMapping
  };
}