"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRedirectLink = void 0;
var _coreApplicationBrowser = require("@kbn/core-application-browser");
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _locators = require("@kbn/deeplinks-observability/locators");
var _common = require("@kbn/discover-plugin/common");
var _esQuery = require("@kbn/es-query");
var _routerUtils = require("@kbn/router-utils");
var _react = require("react");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useRedirectLink = ({
  dataStreamStat,
  query,
  timeRangeConfig,
  breakdownField,
  sendTelemetry,
  selector,
  forceDiscover = false
}) => {
  const {
    services: {
      share,
      application
    }
  } = (0, _utils.useKibanaContextForPlugin)();
  const {
    from,
    to
  } = timeRangeConfig;
  const logsExplorerLocator = share.url.locators.get(_locators.SINGLE_DATASET_LOCATOR_ID);
  const isLogsExplorerAppAccessible = (0, _useObservable.default)((0, _react.useMemo)(() => application.applications$.pipe((0, _rxjs.map)(apps => {
    var _apps$get$status, _apps$get;
    return ((_apps$get$status = (_apps$get = apps.get(_deeplinksObservability.OBSERVABILITY_LOGS_EXPLORER_APP_ID)) === null || _apps$get === void 0 ? void 0 : _apps$get.status) !== null && _apps$get$status !== void 0 ? _apps$get$status : _coreApplicationBrowser.AppStatus.inaccessible) === _coreApplicationBrowser.AppStatus.accessible;
  })), [application.applications$]), false);
  return (0, _react.useMemo)(() => {
    const isLogsExplorerAvailable = !forceDiscover && isLogsExplorerAppAccessible && !!logsExplorerLocator && typeof dataStreamStat !== 'string' && dataStreamStat.type === 'logs';
    const config = isLogsExplorerAvailable ? buildLogsExplorerConfig({
      locator: logsExplorerLocator,
      dataStreamStat,
      query,
      from,
      to,
      breakdownField
    }) : buildDiscoverConfig({
      locatorClient: share.url.locators,
      dataStreamStat,
      query,
      from,
      to,
      breakdownField,
      selector
    });
    const onClickWithTelemetry = event => {
      sendTelemetry();
      if (config.routerLinkProps.onClick) {
        config.routerLinkProps.onClick(event);
      }
    };
    const navigateWithTelemetry = () => {
      sendTelemetry();
      config.navigate();
    };
    return {
      linkProps: {
        ...config.routerLinkProps,
        onClick: onClickWithTelemetry
      },
      navigate: navigateWithTelemetry,
      isLogsExplorerAvailable
    };
  }, [isLogsExplorerAppAccessible, logsExplorerLocator, dataStreamStat, query, from, to, breakdownField, share.url.locators, selector, sendTelemetry, forceDiscover]);
};
exports.useRedirectLink = useRedirectLink;
const buildLogsExplorerConfig = ({
  locator,
  dataStreamStat,
  query,
  from,
  to,
  breakdownField
}) => {
  var _dataStreamStat$integ;
  const params = {
    dataset: dataStreamStat.name,
    timeRange: {
      from,
      to
    },
    integration: (_dataStreamStat$integ = dataStreamStat.integration) === null || _dataStreamStat$integ === void 0 ? void 0 : _dataStreamStat$integ.name,
    query,
    filterControls: {
      namespace: {
        mode: 'include',
        values: [dataStreamStat.namespace]
      }
    },
    breakdownField
  };
  const urlToLogsExplorer = locator.getRedirectUrl(params);
  const navigateToLogsExplorer = () => {
    locator.navigate(params);
  };
  const logsExplorerLinkProps = (0, _routerUtils.getRouterLinkProps)({
    href: urlToLogsExplorer,
    onClick: navigateToLogsExplorer
  });
  return {
    routerLinkProps: logsExplorerLinkProps,
    navigate: navigateToLogsExplorer
  };
};
const buildDiscoverConfig = ({
  locatorClient,
  dataStreamStat,
  query,
  from,
  to,
  breakdownField,
  selector
}) => {
  const {
    dataViewId,
    dataViewTitle
  } = getDataView({
    dataStreamStat,
    selector
  });
  const filters = getFilters({
    dataStreamStat,
    dataViewId,
    dataViewTitle,
    selector
  });
  const params = {
    timeRange: {
      from,
      to
    },
    refreshInterval: {
      pause: true,
      value: 60000
    },
    dataViewId,
    dataViewSpec: {
      id: dataViewId,
      title: dataViewId,
      timeFieldName: '@timestamp'
    },
    query,
    breakdownField,
    columns: [],
    filters,
    interval: 'auto',
    sort: [['@timestamp', 'desc']]
  };
  const locator = locatorClient.get(_common.DISCOVER_APP_LOCATOR);
  const urlToDiscover = locator === null || locator === void 0 ? void 0 : locator.getRedirectUrl(params);
  const navigateToDiscover = () => {
    locator === null || locator === void 0 ? void 0 : locator.navigate(params);
  };
  const discoverLinkProps = (0, _routerUtils.getRouterLinkProps)({
    href: urlToDiscover,
    onClick: navigateToDiscover
  });
  return {
    routerLinkProps: discoverLinkProps,
    navigate: navigateToDiscover
  };
};
const getDataView = ({
  dataStreamStat,
  selector
}) => {
  if (dataStreamStat && typeof dataStreamStat === 'string') {
    return {
      dataViewId: dataStreamStat,
      dataViewTitle: dataStreamStat
    };
  }
  const {
    name,
    namespace,
    type,
    integration
  } = dataStreamStat;
  const dataViewNamespace = `${namespace || '*'}`;
  const dataViewSelector = selector ? `${selector}` : '';
  const dataViewId = `${type}-${name}-${dataViewNamespace}${dataViewSelector}`;
  const dataViewTitle = integration ? `[${integration.title}] ${name}-${dataViewNamespace}${dataViewSelector}` : `${dataViewId}`;
  return {
    dataViewId,
    dataViewTitle
  };
};
const getFilters = ({
  dataStreamStat,
  dataViewId,
  dataViewTitle,
  selector
}) => {
  if (dataStreamStat && typeof dataStreamStat === 'string') {
    return [];
  }
  return selector ? [] : [(0, _esQuery.buildPhraseFilter)({
    name: 'data_stream.namespace',
    type: 'string'
  }, dataStreamStat.namespace, {
    id: dataViewId,
    title: dataViewTitle
  })];
};