"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateDataView = useCreateDataView;
var _react = require("react");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useCreateDataView({
  indexPatternString
}) {
  const {
    services: {
      dataViews
    }
  } = (0, _utils.useKibanaContextForPlugin)();
  const [stateDataView, setStateDataView] = (0, _react.useState)();
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    const retrieveOrCreateDataView = async indexPattern => {
      const existingDataView = await dataViews.getIdsWithTitle();
      const foundDataView = existingDataView.find(dv => dv.title === indexPattern);
      if (foundDataView) {
        return dataViews.get(foundDataView.id);
      }

      // Create an ad-hoc data view
      return dataViews.create({
        id: `${indexPatternString}-id`,
        title: indexPatternString,
        allowNoIndex: true,
        timeFieldName: '@timestamp'
      });
    };
    if (indexPatternString) {
      setIsLoading(true);
      retrieveOrCreateDataView(indexPatternString).then(value => {
        setStateDataView(value);
      }).finally(() => {
        setIsLoading(false);
      });
    }
  }, [indexPatternString, dataViews]);
  return {
    dataView: stateDataView,
    loading: isLoading
  };
}