"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDateFieldsStatsRequest = exports.fetchDateFieldsStats = void 0;
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _mlErrorUtils = require("@kbn/ml-error-utils");
var _build_random_sampler_agg = require("./build_random_sampler_agg");
var _field_stats = require("../../../../../common/types/field_stats");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDateFieldsStatsRequest = (params, fields) => {
  const {
    index,
    query,
    runtimeFieldMap
  } = params;
  const size = 0;
  const aggs = {};
  fields.forEach((field, i) => {
    const safeFieldName = field.safeFieldName;
    aggs[`${safeFieldName}_field_stats`] = {
      filter: {
        exists: {
          field: field.fieldName
        }
      },
      aggs: {
        actual_stats: {
          stats: {
            field: field.fieldName
          }
        }
      }
    };
  });
  const searchBody = {
    query,
    aggs: (0, _build_random_sampler_agg.buildAggregationWithSamplingOption)(aggs, params.samplingOption),
    ...((0, _mlIsPopulatedObject.isPopulatedObject)(runtimeFieldMap) ? {
      runtime_mappings: runtimeFieldMap
    } : {})
  };
  return {
    index,
    size,
    body: searchBody
  };
};
exports.getDateFieldsStatsRequest = getDateFieldsStatsRequest;
const fetchDateFieldsStats = (dataSearch, params, fields, options) => {
  const request = getDateFieldsStatsRequest(params, fields);
  return dataSearch.search({
    params: request
  }, options).pipe((0, _rxjs.catchError)(e => (0, _rxjs.of)({
    fields,
    error: (0, _mlErrorUtils.extractErrorProperties)(e)
  })), (0, _rxjs.map)(resp => {
    if (!(0, _field_stats.isIKibanaSearchResponse)(resp)) return resp;
    const aggregations = resp.rawResponse.aggregations;
    const aggsPath = ['sample'];
    const batchStats = fields.map((field, i) => {
      const safeFieldName = field.safeFieldName;
      const fieldStatsResp = (0, _lodash.get)(aggregations, [...aggsPath, `${safeFieldName}_field_stats`, 'actual_stats'], {});
      return {
        fieldName: field.fieldName,
        earliest: (0, _lodash.get)(fieldStatsResp, 'min', 0),
        latest: (0, _lodash.get)(fieldStatsResp, 'max', 0)
      };
    });
    return batchStats;
  }));
};
exports.fetchDateFieldsStats = fetchDateFieldsStats;