"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexDataVisualizerLocatorDefinition = exports.DATA_VISUALIZER_APP_LOCATOR = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rison = require("@kbn/rison");
var _queryString = require("query-string");
var _mlUrlState = require("@kbn/ml-url-state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DATA_VISUALIZER_APP_LOCATOR = exports.DATA_VISUALIZER_APP_LOCATOR = 'DATA_VISUALIZER_APP_LOCATOR';
class IndexDataVisualizerLocatorDefinition {
  constructor() {
    (0, _defineProperty2.default)(this, "id", DATA_VISUALIZER_APP_LOCATOR);
    (0, _defineProperty2.default)(this, "getLocation", async params => {
      const {
        dataViewId,
        query,
        refreshInterval,
        savedSearchId,
        timeRange,
        visibleFieldNames,
        visibleFieldTypes,
        searchSessionId,
        filters,
        showAllFields,
        showEmptyFields,
        pageSize,
        sortDirection,
        samplerShardSize,
        pageIndex,
        sortField,
        showDistributions
      } = params;
      const appState = {};
      const queryState = {};
      if (query) {
        appState.searchQuery = query.searchQuery;
        appState.searchString = query.searchString;
        appState.searchQueryLanguage = query.searchQueryLanguage;
      }
      if (params.searchString) {
        appState.searchQuery = params.searchQuery;
        appState.searchString = params.searchString;
        appState.searchQueryLanguage = params.searchQueryLanguage;
      }
      if (filters) {
        appState.filters = filters;
      }
      if (visibleFieldNames) appState.visibleFieldNames = visibleFieldNames;
      if (visibleFieldTypes) appState.visibleFieldTypes = visibleFieldTypes;
      if (pageSize) appState.pageSize = pageSize;
      if (sortDirection) appState.sortDirection = sortDirection;
      if (samplerShardSize) appState.samplerShardSize = samplerShardSize;
      if (pageIndex) appState.pageIndex = pageIndex;
      if (sortField) appState.sortField = sortField;
      if (showDistributions !== undefined) appState.showDistributions = showDistributions;
      if (showAllFields !== undefined) appState.showAllFields = showAllFields;
      if (showEmptyFields !== undefined) appState.showEmptyFields = showEmptyFields;
      if (timeRange) queryState.time = timeRange;
      if (refreshInterval) queryState.refreshInterval = refreshInterval;
      const urlState = {
        ...(savedSearchId ? {
          savedSearchId
        } : {
          index: dataViewId
        }),
        ...(searchSessionId ? {
          searchSessionId
        } : {}),
        _a: {
          DATA_VISUALIZER_INDEX_VIEWER: appState
        },
        _g: queryState
      };
      const parsedQueryString = {};
      Object.keys(urlState).forEach(a => {
        if ((0, _mlUrlState.isRisonSerializationRequired)(a)) {
          parsedQueryString[a] = (0, _rison.encode)(urlState[a]);
        } else {
          parsedQueryString[a] = urlState[a];
        }
      });
      const newLocationSearchString = (0, _queryString.stringify)(parsedQueryString, {
        sort: false,
        encode: false
      });
      const path = `/jobs/new_job/datavisualizer?${newLocationSearchString}`;
      return {
        app: 'ml',
        path,
        state: {}
      };
    });
  }
}
exports.IndexDataVisualizerLocatorDefinition = IndexDataVisualizerLocatorDefinition;