"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocCountChart = void 0;
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _mlTimeBuckets = require("@kbn/ml-time-buckets");
var _import_progress = require("../import_progress");
var _event_rate_chart = require("./event_rate_chart");
var _doc_count_search = require("./doc_count_search");
var _kibana_context = require("../../../kibana_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BAR_TARGET = 150;
const PROGRESS_INCREMENT = 5;
const FINISHED_CHECKS = 10;
const FINISHED_CHECKS_INTERVAL_MS = 2 * 1000;
const ERROR_ATTEMPTS = 3;
const BACK_FILL_BUCKETS = 8;
const DocCountChart = ({
  statuses,
  dataStart,
  importer
}) => {
  const {
    services
  } = (0, _kibana_context.useDataVisualizerKibana)();
  const {
    uiSettings
  } = services;
  const timeBuckets = (0, _mlTimeBuckets.useTimeBuckets)(uiSettings);
  const index = (0, _react.useMemo)(() => importer.getIndex(), [importer]);
  const timeField = (0, _react.useMemo)(() => importer.getTimeField(), [importer]);
  const [loading, setLoading] = (0, _react.useState)(false);
  const [loadingTimeRange, setLoadingTimeRange] = (0, _react.useState)(false);
  const [finished, setFinished] = (0, _react.useState)(false);
  const [previousProgress, setPreviousProgress] = (0, _react.useState)(0);
  const [lastNonZeroTimeMs, setLastNonZeroTimeMs] = (0, _react.useState)(undefined);
  const [eventRateChartData, setEventRateChartData] = (0, _react.useState)([]);
  const [timeRange, setTimeRange] = (0, _react.useState)(undefined);
  const [dataReady, setDataReady] = (0, _react.useState)(false);
  const loadFullData = (0, _react.useRef)(false);
  const [errorAttempts, setErrorAttempts] = (0, _react.useState)(ERROR_ATTEMPTS);
  const recordFailure = (0, _react.useCallback)(() => {
    setErrorAttempts(errorAttempts - 1);
  }, [errorAttempts]);
  const loadData = (0, _react.useCallback)(async () => {
    if (timeField === undefined || index === undefined || timeRange === undefined) {
      return;
    }
    setLoading(true);
    timeBuckets.setInterval('auto');
    const {
      start,
      end
    } = timeRange;
    const fullData = loadFullData.current;
    try {
      var _lastNonZeroTimeMs$in;
      const startMs = fullData === true || lastNonZeroTimeMs === undefined ? start.valueOf() : lastNonZeroTimeMs.time;
      const endMs = end.valueOf();
      if (start != null && end != null) {
        timeBuckets.setBounds({
          min: start,
          max: end
        });
        timeBuckets.setBarTarget(BAR_TARGET);
      }
      const data = await (0, _doc_count_search.runDocCountSearch)(dataStart, index, timeField, startMs, endMs, timeBuckets);
      const newData = fullData === true ? data : [...eventRateChartData].splice(0, (_lastNonZeroTimeMs$in = lastNonZeroTimeMs === null || lastNonZeroTimeMs === void 0 ? void 0 : lastNonZeroTimeMs.index) !== null && _lastNonZeroTimeMs$in !== void 0 ? _lastNonZeroTimeMs$in : 0).concat(data);
      if (dataReady === false && newData.some(d => d.value > 0)) {
        setDataReady(true);
      }
      setEventRateChartData(newData);
      setLastNonZeroTimeMs(findLastTimestamp(newData, BACK_FILL_BUCKETS));
    } catch (error) {
      recordFailure();
    }
    setLoading(false);
  }, [timeField, index, timeRange, timeBuckets, lastNonZeroTimeMs, dataStart, dataReady, eventRateChartData, recordFailure]);
  const finishedChecks = (0, _react.useCallback)(async counter => {
    loadData();
    if (counter !== 0) {
      setTimeout(() => {
        finishedChecks(counter - 1);
      }, FINISHED_CHECKS_INTERVAL_MS);
    }
  }, [loadData]);
  const loadTimeRange = (0, _react.useCallback)(async () => {
    if (loadingTimeRange === true) {
      return;
    }
    setLoadingTimeRange(true);
    try {
      const {
        start,
        end
      } = await importer.previewIndexTimeRange();
      if (start === null || end === null || start >= end) {
        throw new Error('Invalid time range');
      }
      setTimeRange({
        start: (0, _moment.default)(start),
        end: (0, _moment.default)(end)
      });
    } catch (error) {
      recordFailure();
    }
    setLoadingTimeRange(false);
  }, [importer, loadingTimeRange, recordFailure]);
  (0, _react.useEffect)(function loadProgress() {
    if (errorAttempts === 0) {
      return;
    }
    if (timeRange === undefined) {
      loadTimeRange();
      return;
    }
    if (loading === false && statuses.uploadProgress > 1 && statuses.uploadProgress < 100) {
      if (statuses.uploadProgress - previousProgress > PROGRESS_INCREMENT) {
        setPreviousProgress(statuses.uploadProgress);
        loadData();
      }
    } else if (loading === false && statuses.uploadProgress === 100 && finished === false) {
      setFinished(true);
      finishedChecks(FINISHED_CHECKS);
      loadFullData.current = true;
    }
  }, [finished, finishedChecks, loadData, loadTimeRange, loading, loadingTimeRange, previousProgress, statuses, timeRange, errorAttempts]);
  if (timeField === undefined || statuses.indexCreatedStatus === _import_progress.IMPORT_STATUS.INCOMPLETE || statuses.ingestPipelineCreatedStatus === _import_progress.IMPORT_STATUS.INCOMPLETE || errorAttempts === 0 || eventRateChartData.length === 0 || dataReady === false) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_event_rate_chart.EventRateChart, {
    eventRateChartData: eventRateChartData,
    height: '150px',
    width: '100%'
  }));
};

/**
 * Finds the last non-zero data point in the chart data
 * backFillOffset can be set to jump back a number of buckets from the final non-zero bucket.
 * This means the next time we load data, refresh the last n buckets of data in case there are new documents.
 * @param data LineChartPoint[]
 * @param backFillOffset number
 * @returns
 */
exports.DocCountChart = DocCountChart;
function findLastTimestamp(data, backFillOffset = 0) {
  let lastNonZeroDataPoint = data[0].time;
  let index = 0;
  for (let i = 0; i < data.length; i++) {
    if (data[i].value > 0) {
      const backTrackIndex = i - backFillOffset >= 0 ? i - backFillOffset : i;
      lastNonZeroDataPoint = data[backTrackIndex].time;
      index = backTrackIndex;
    } else {
      break;
    }
  }
  return {
    index,
    time: lastNonZeroDataPoint
  };
}