"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUniqGeoOrStrExamples = getUniqGeoOrStrExamples;
exports.isGeoPointExample = isGeoPointExample;
exports.isLonLatExample = isLonLatExample;
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _mlIsDefined = require("@kbn/ml-is-defined");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isGeoPointExample(arg) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(arg, ['coordinates']) && Array.isArray(arg.coordinates);
}
function isLonLatExample(arg) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(arg, ['lon', 'lat']);
}
function getUniqGeoOrStrExamples(examples, maxExamples = 10) {
  const uniqueCoordinates = [];
  if (!(0, _mlIsDefined.isDefined)(examples)) return uniqueCoordinates;
  for (let i = 0; i < examples.length; i++) {
    const example = examples[i];
    if (typeof example === 'string' && uniqueCoordinates.indexOf(example) === -1) {
      uniqueCoordinates.push(example);
    } else {
      if (isGeoPointExample(example) && uniqueCoordinates.findIndex(c => isGeoPointExample(c) && c.type === example.type && example.coordinates.every((coord, idx) => coord === c.coordinates[idx])) === -1) {
        uniqueCoordinates.push(example);
      }
      if (isLonLatExample(example) && uniqueCoordinates.findIndex(c => isLonLatExample(c) && example.lon === c.lon && example.lat === c.lat) === -1) {
        uniqueCoordinates.push(example);
      }
    }
    if (uniqueCoordinates.length === maxExamples) {
      return uniqueCoordinates;
    }
  }
  return uniqueCoordinates;
}