"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBooleanSettings = getBooleanSettings;
exports.getCompatibleLensDataType = getCompatibleLensDataType;
exports.getDateSettings = getDateSettings;
exports.getKeywordSettings = getKeywordSettings;
exports.getLensAttributes = getLensAttributes;
exports.getNumberSettings = getNumberSettings;
var _i18n = require("@kbn/i18n");
var _constants = require("@kbn/lens-plugin/common/constants");
var _constants2 = require("../../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TOP_VALUES_LABEL = _i18n.i18n.translate('xpack.dataVisualizer.index.lensChart.topValuesLabel', {
  defaultMessage: 'Top values'
});
const COUNT = _i18n.i18n.translate('xpack.dataVisualizer.index.lensChart.countLabel', {
  defaultMessage: 'Count'
});
function getNumberSettings(item, defaultDataView) {
  var _item$supportedAggs;
  // if index has no timestamp field
  if (defaultDataView.timeFieldName === undefined) {
    const columns = {
      col1: {
        label: item.fieldName,
        dataType: 'number',
        isBucketed: true,
        operationType: 'range',
        params: {
          type: 'histogram',
          maxBars: 'auto',
          ranges: []
        },
        sourceField: item.fieldName
      },
      col2: {
        label: COUNT,
        dataType: 'number',
        isBucketed: false,
        sourceField: _constants.DOCUMENT_FIELD_NAME,
        operationType: 'count'
      }
    };
    const layer = {
      accessors: ['col2'],
      layerId: 'layer1',
      layerType: 'data',
      seriesType: 'bar',
      xAccessor: 'col1'
    };
    return {
      columns,
      layer
    };
  }
  const operationType = (_item$supportedAggs = item.supportedAggs) !== null && _item$supportedAggs !== void 0 && _item$supportedAggs.has('avg') ? 'average' : 'max';
  const operationLabel = operationType === 'average' ? _i18n.i18n.translate('xpack.dataVisualizer.index.lensChart.averageOfLabel', {
    defaultMessage: 'Average of {fieldName}',
    values: {
      fieldName: item.fieldName
    }
  }) : _i18n.i18n.translate('xpack.dataVisualizer.index.lensChart.maximumOfLabel', {
    defaultMessage: 'Maximum of {fieldName}',
    values: {
      fieldName: item.fieldName
    }
  });
  const columns = {
    col2: {
      dataType: 'number',
      isBucketed: false,
      label: operationLabel,
      operationType,
      sourceField: item.fieldName
    },
    col1: {
      dataType: 'date',
      isBucketed: true,
      label: defaultDataView.timeFieldName,
      operationType: 'date_histogram',
      params: {
        interval: 'auto'
      },
      scale: 'interval',
      sourceField: defaultDataView.timeFieldName
    }
  };
  const layer = {
    accessors: ['col2'],
    layerId: 'layer1',
    layerType: 'data',
    seriesType: 'line',
    xAccessor: 'col1'
  };
  return {
    columns,
    layer
  };
}
function getDateSettings(item) {
  const columns = {
    col2: {
      dataType: 'number',
      isBucketed: false,
      label: COUNT,
      operationType: 'count',
      scale: 'ratio',
      sourceField: _constants.DOCUMENT_FIELD_NAME
    },
    col1: {
      dataType: 'date',
      isBucketed: true,
      label: item.fieldName,
      operationType: 'date_histogram',
      params: {
        interval: 'auto'
      },
      scale: 'interval',
      sourceField: item.fieldName
    }
  };
  const layer = {
    accessors: ['col2'],
    layerId: 'layer1',
    layerType: 'data',
    seriesType: 'line',
    xAccessor: 'col1'
  };
  return {
    columns,
    layer
  };
}
function getKeywordSettings(item) {
  const columns = {
    col1: {
      label: TOP_VALUES_LABEL,
      dataType: 'string',
      isBucketed: true,
      operationType: 'terms',
      params: {
        orderBy: {
          type: 'column',
          columnId: 'col2'
        },
        size: 10,
        orderDirection: 'desc'
      },
      sourceField: item.fieldName
    },
    col2: {
      label: COUNT,
      dataType: 'number',
      isBucketed: false,
      sourceField: _constants.DOCUMENT_FIELD_NAME,
      operationType: 'count'
    }
  };
  const layer = {
    accessors: ['col2'],
    layerId: 'layer1',
    layerType: 'data',
    seriesType: 'bar',
    xAccessor: 'col1'
  };
  return {
    columns,
    layer
  };
}
function getBooleanSettings(item) {
  const columns = {
    col1: {
      label: TOP_VALUES_LABEL,
      dataType: 'string',
      isBucketed: true,
      operationType: 'terms',
      params: {
        orderBy: {
          type: 'alphabetical'
        },
        size: 2,
        orderDirection: 'desc'
      },
      sourceField: item.fieldName
    },
    col2: {
      label: COUNT,
      dataType: 'number',
      isBucketed: false,
      sourceField: _constants.DOCUMENT_FIELD_NAME,
      operationType: 'count'
    }
  };
  const layer = {
    accessors: ['col2'],
    layerId: 'layer1',
    layerType: 'data',
    seriesType: 'bar',
    xAccessor: 'col1'
  };
  return {
    columns,
    layer
  };
}
function getCompatibleLensDataType(type) {
  let lensType;
  switch (type) {
    case _constants2.SUPPORTED_FIELD_TYPES.KEYWORD:
    case _constants2.SUPPORTED_FIELD_TYPES.VERSION:
      lensType = 'string';
      break;
    case _constants2.SUPPORTED_FIELD_TYPES.DATE:
      lensType = 'date';
      break;
    case _constants2.SUPPORTED_FIELD_TYPES.NUMBER:
      lensType = 'number';
      break;
    case _constants2.SUPPORTED_FIELD_TYPES.IP:
      lensType = 'ip';
      break;
    case _constants2.SUPPORTED_FIELD_TYPES.BOOLEAN:
      lensType = 'string';
      break;
    default:
      lensType = undefined;
  }
  return lensType;
}
function getColumnsAndLayer(fieldType, item, defaultDataView) {
  if (item.fieldName === undefined) return;
  if (fieldType === _constants2.SUPPORTED_FIELD_TYPES.DATE) {
    return getDateSettings(item);
  }
  if (fieldType === _constants2.SUPPORTED_FIELD_TYPES.NUMBER) {
    return getNumberSettings(item, defaultDataView);
  }
  if (fieldType === _constants2.SUPPORTED_FIELD_TYPES.IP || fieldType === _constants2.SUPPORTED_FIELD_TYPES.KEYWORD || fieldType === _constants2.SUPPORTED_FIELD_TYPES.VERSION) {
    return getKeywordSettings(item);
  }
  if (fieldType === _constants2.SUPPORTED_FIELD_TYPES.BOOLEAN) {
    return getBooleanSettings(item);
  }
}
// Get formatted Lens visualization format depending on field type
// currently only supports the following types:
// 'document' | 'string' | 'number' | 'date' | 'boolean' | 'ip'
function getLensAttributes(defaultDataView, combinedQuery, filters, item) {
  if (defaultDataView === undefined || item.type === undefined || item.fieldName === undefined) return;
  const presets = getColumnsAndLayer(item.type, item, defaultDataView);
  if (!presets) return;
  return {
    visualizationType: 'lnsXY',
    title: _i18n.i18n.translate('xpack.dataVisualizer.index.lensChart.chartTitle', {
      defaultMessage: 'Lens for {fieldName}',
      values: {
        fieldName: item.fieldName
      }
    }),
    references: [{
      id: defaultDataView.id,
      name: 'indexpattern-datasource-current-indexpattern',
      type: 'index-pattern'
    }, {
      id: defaultDataView.id,
      name: 'indexpattern-datasource-layer-layer1',
      type: 'index-pattern'
    }],
    state: {
      datasourceStates: {
        formBased: {
          layers: {
            layer1: {
              columnOrder: ['col1', 'col2'],
              columns: presets.columns
            }
          }
        }
      },
      filters,
      query: {
        language: combinedQuery.searchQueryLanguage,
        query: combinedQuery.searchString
      },
      visualization: {
        axisTitlesVisibilitySettings: {
          x: true,
          yLeft: true,
          yRight: true
        },
        fittingFunction: 'None',
        gridlinesVisibilitySettings: {
          x: true,
          yLeft: true,
          yRight: true
        },
        layers: [presets.layer],
        legend: {
          isVisible: true,
          position: 'right'
        },
        preferredSeriesType: 'line',
        tickLabelsVisibilitySettings: {
          x: true,
          yLeft: true,
          yRight: true
        },
        valueLabels: 'hide'
      }
    }
  };
}