"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldFormatEditors = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class FieldFormatEditors {
  constructor() {
    (0, _defineProperty2.default)(this, "editors", []);
  }
  setup(defaultFieldEditors = []) {
    this.editors = defaultFieldEditors;
    return {
      register: editor => {
        this.editors.push(editor);
      }
    };
  }
  start() {
    return {
      getAll: () => [...this.editors],
      getById: id => {
        return this.editors.find(editor => editor.formatId === id);
      }
    };
  }
}
exports.FieldFormatEditors = FieldFormatEditors;