"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartsLoading = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _use_test_id_generator = require("../../hooks/use_test_id_generator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ChartsLoading = ({
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  // returns 2 loading icons for the two charts
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "center",
    "data-test-subj": getTestId('charts-loading')
  }, [...Array(2)].map(i => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: i
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "xl",
    hasShadow: false,
    hasBorder: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    size: "l"
  })))));
};
exports.ChartsLoading = ChartsLoading;
ChartsLoading.displayName = 'ChartsLoading';