"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SCHEMA_QUERY_V8_8_0 = exports.SCHEMA_QUERY_MODEL_VERSION_2 = exports.SCHEMA_QUERY_MODEL_VERSION_1 = exports.SCHEMA_QUERY_BASE = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const FILTERS_SCHEMA = _configSchema.schema.arrayOf(_configSchema.schema.object({}, {
  unknowns: 'allow'
}));
const TIME_FILTER_SCHEMA = _configSchema.schema.object({
  from: _configSchema.schema.string(),
  to: _configSchema.schema.string(),
  refreshInterval: _configSchema.schema.maybe(_configSchema.schema.object({
    value: _configSchema.schema.number(),
    pause: _configSchema.schema.boolean()
  }))
});

// As per `SavedQueryAttributes`
const SCHEMA_QUERY_BASE = exports.SCHEMA_QUERY_BASE = _configSchema.schema.object({
  title: _configSchema.schema.string(),
  description: _configSchema.schema.string({
    defaultValue: ''
  }),
  query: _configSchema.schema.object({
    language: _configSchema.schema.string(),
    query: _configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.object({}, {
      unknowns: 'allow'
    })])
  }),
  filters: _configSchema.schema.maybe(FILTERS_SCHEMA),
  timefilter: _configSchema.schema.maybe(TIME_FILTER_SCHEMA)
});
const SCHEMA_QUERY_V8_8_0 = exports.SCHEMA_QUERY_V8_8_0 = SCHEMA_QUERY_BASE;
const SCHEMA_QUERY_MODEL_VERSION_1 = exports.SCHEMA_QUERY_MODEL_VERSION_1 = SCHEMA_QUERY_BASE;
const SCHEMA_QUERY_MODEL_VERSION_2 = exports.SCHEMA_QUERY_MODEL_VERSION_2 = SCHEMA_QUERY_BASE.extends({
  titleKeyword: _configSchema.schema.string(),
  filters: _configSchema.schema.maybe(_configSchema.schema.nullable(FILTERS_SCHEMA)),
  timefilter: _configSchema.schema.maybe(_configSchema.schema.nullable(TIME_FILTER_SCHEMA))
});