"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "DEFAULT_QUERY_LANGUAGE", {
  enumerable: true,
  get: function () {
    return _common.DEFAULT_QUERY_LANGUAGE;
  }
});
Object.defineProperty(exports, "DataView", {
  enumerable: true,
  get: function () {
    return _common.DataView;
  }
});
Object.defineProperty(exports, "DataViewsCommonService", {
  enumerable: true,
  get: function () {
    return _common.DataViewsService;
  }
});
Object.defineProperty(exports, "ES_FIELD_TYPES", {
  enumerable: true,
  get: function () {
    return _common.ES_FIELD_TYPES;
  }
});
Object.defineProperty(exports, "ES_SEARCH_STRATEGY", {
  enumerable: true,
  get: function () {
    return _common.ES_SEARCH_STRATEGY;
  }
});
Object.defineProperty(exports, "INITIAL_SEARCH_SESSION_REST_VERSION", {
  enumerable: true,
  get: function () {
    return _search.INITIAL_SEARCH_SESSION_REST_VERSION;
  }
});
Object.defineProperty(exports, "IndexPatternsFetcher", {
  enumerable: true,
  get: function () {
    return _data_views.IndexPatternsFetcher;
  }
});
Object.defineProperty(exports, "KBN_FIELD_TYPES", {
  enumerable: true,
  get: function () {
    return _common.KBN_FIELD_TYPES;
  }
});
Object.defineProperty(exports, "METRIC_TYPES", {
  enumerable: true,
  get: function () {
    return _common.METRIC_TYPES;
  }
});
Object.defineProperty(exports, "NoSearchIdInSessionError", {
  enumerable: true,
  get: function () {
    return _search.NoSearchIdInSessionError;
  }
});
Object.defineProperty(exports, "SearchSessionService", {
  enumerable: true,
  get: function () {
    return _search.SearchSessionService;
  }
});
Object.defineProperty(exports, "UI_SETTINGS", {
  enumerable: true,
  get: function () {
    return _common.UI_SETTINGS;
  }
});
exports.exporters = exports.config = void 0;
Object.defineProperty(exports, "getCapabilitiesForRollupIndices", {
  enumerable: true,
  get: function () {
    return _data_views.getCapabilitiesForRollupIndices;
  }
});
Object.defineProperty(exports, "getEsQueryConfig", {
  enumerable: true,
  get: function () {
    return _common.getEsQueryConfig;
  }
});
Object.defineProperty(exports, "getRequestAbortedSignal", {
  enumerable: true,
  get: function () {
    return _lib.getRequestAbortedSignal;
  }
});
Object.defineProperty(exports, "getTime", {
  enumerable: true,
  get: function () {
    return _common.getTime;
  }
});
Object.defineProperty(exports, "parseInterval", {
  enumerable: true,
  get: function () {
    return _common.parseInterval;
  }
});
exports.plugin = plugin;
exports.search = void 0;
Object.defineProperty(exports, "shimHitsTotal", {
  enumerable: true,
  get: function () {
    return _search2.shimHitsTotal;
  }
});
var _config = require("./config");
var _common = require("../common");
var _lib = require("./lib");
var _data_views = require("./data_views");
var _config_deprecations = require("./config_deprecations");
var _search = require("./search");
var _search2 = require("../common/search");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */ /**
 * Exporters (CSV)
 */
const exporters = exports.exporters = {
  datatableToCSV: _common.datatableToCSV,
  CSV_MIME_TYPE: _common.CSV_MIME_TYPE
};

/*
 * Index patterns:
 */

/**
 * Search
 */

// Search namespace
const search = exports.search = {
  aggs: {
    CidrMask: _common.CidrMask,
    dateHistogramInterval: _common.dateHistogramInterval,
    IpAddress: _common.IpAddress,
    parseInterval: _common.parseInterval,
    calcAutoIntervalLessThan: _common.calcAutoIntervalLessThan
  }
};

/**
 * Types to be shared externally
 * @public
 */

/**
 * Static code to be shared externally
 * @public
 */

async function plugin(initializerContext) {
  const {
    DataServerPlugin
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('./plugin')));
  return new DataServerPlugin(initializerContext);
}
const config = exports.config = {
  deprecations: _config_deprecations.configDeprecationProvider,
  exposeToBrowser: {
    search: true,
    query: true
  },
  schema: _config.configSchema
};