"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dateString = void 0;
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const dateString = (inputString, tz) => {
  if (inputString == null) {
    throw new Error('Invalid date string!');
  }
  let returnString;
  if (tz === 'Browser') {
    returnString = _momentTimezone.default.utc(inputString).tz(_momentTimezone.default.tz.guess()).format(_types.DATE_STRING_FORMAT);
  } else {
    returnString = (0, _momentTimezone.default)(inputString).tz(tz).format(_types.DATE_STRING_FORMAT);
  }
  return returnString;
};
exports.dateString = dateString;