"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAddToQueryLog = createAddToQueryLog;
var _get_query_log = require("./get_query_log");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function createAddToQueryLog({
  storage,
  uiSettings
}) {
  /**
   * This function is to be used in conjunction with `<QueryStringInput />`.
   * It provides a way for external editors to add new filter entries to the
   * persisted query log which lives in `localStorage`. These entries are then
   * read by `<QueryStringInput />` and provided in the autocomplete options.
   *
   * @param appName Name of the app where this filter is added from.
   * @param query Filter value to add.
   */
  return function addToQueryLog(appName, {
    language,
    query
  }) {
    const persistedLog = (0, _get_query_log.getQueryLog)(uiSettings, storage, appName, language);
    persistedLog.add(query);
  };
}