"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformOptionsOut = transformOptionsOut;
var _lodash = require("lodash");
var _content_management = require("../../../../../common/content_management");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function transformOptionsOut(optionsJSON) {
  return (0, _lodash.flow)(JSON.parse, transformOptionsSetDefaults, transformOptionsProperties)(optionsJSON);
}

// TODO We may want to remove setting defaults in the future
function transformOptionsSetDefaults(options) {
  return {
    ..._content_management.DEFAULT_DASHBOARD_OPTIONS,
    ...options
  };
}
function transformOptionsProperties({
  hidePanelTitles,
  useMargins,
  syncColors,
  syncCursor,
  syncTooltips
}) {
  return {
    hidePanelTitles,
    useMargins,
    syncColors,
    syncCursor,
    syncTooltips
  };
}