"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDashboardBackupService = exports.PANELS_CONTROL_GROUP_KEY = exports.DASHBOARD_PANELS_UNSAVED_ID = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-utils-plugin/public");
var _saferLodashSet = require("@kbn/safer-lodash-set");
var _kibana_services = require("./kibana_services");
var _default_dashboard_state = require("../dashboard_api/default_dashboard_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DASHBOARD_PANELS_UNSAVED_ID = exports.DASHBOARD_PANELS_UNSAVED_ID = 'unsavedDashboard';
const PANELS_CONTROL_GROUP_KEY = exports.PANELS_CONTROL_GROUP_KEY = 'controlGroup';
const DASHBOARD_VIEWMODE_LOCAL_KEY = 'dashboardViewMode';

// this key is named `panels` for BWC reasons, but actually contains the entire dashboard state
const DASHBOARD_STATE_SESSION_KEY = 'dashboardStateManagerPanels';

// Temporary key for Dashboard to back up serialized state of all its panels
const DASHBOARD_SERIALIZED_PANEL_BACKUP_KEY = 'dashboardSerializedPanelBackup';
const getPanelsGetError = message => _i18n.i18n.translate('dashboard.panelStorageError.getError', {
  defaultMessage: 'Error encountered while fetching unsaved changes: {message}',
  values: {
    message
  }
});
class DashboardBackupService {
  constructor() {
    (0, _defineProperty2.default)(this, "activeSpaceId", void 0);
    (0, _defineProperty2.default)(this, "sessionStorage", void 0);
    (0, _defineProperty2.default)(this, "localStorage", void 0);
    (0, _defineProperty2.default)(this, "oldDashboardsWithUnsavedChanges", []);
    (0, _defineProperty2.default)(this, "getViewMode", () => {
      var _this$localStorage$ge;
      return (_this$localStorage$ge = this.localStorage.get(DASHBOARD_VIEWMODE_LOCAL_KEY)) !== null && _this$localStorage$ge !== void 0 ? _this$localStorage$ge : _default_dashboard_state.DEFAULT_DASHBOARD_STATE.viewMode;
    });
    (0, _defineProperty2.default)(this, "storeViewMode", viewMode => {
      try {
        this.localStorage.set(DASHBOARD_VIEWMODE_LOCAL_KEY, viewMode);
      } catch (e) {
        _kibana_services.coreServices.notifications.toasts.addDanger({
          title: _i18n.i18n.translate('dashboard.viewmodeBackup.error', {
            defaultMessage: 'Error encountered while backing up view mode: {message}',
            values: {
              message: e.message
            }
          }),
          'data-test-subj': 'dashboardViewmodeBackupFailure'
        });
      }
    });
    this.sessionStorage = new _public.Storage(sessionStorage);
    this.localStorage = new _public.Storage(localStorage);
    this.activeSpaceId = 'default';
    if (_kibana_services.spacesService) {
      (0, _rxjs.firstValueFrom)(_kibana_services.spacesService.getActiveSpace$()).then(space => {
        this.activeSpaceId = space.id;
      });
    }
  }
  clearState(id = DASHBOARD_PANELS_UNSAVED_ID) {
    try {
      var _this$sessionStorage$, _this$sessionStorage$2;
      const dashboardStateStorage = (_this$sessionStorage$ = (_this$sessionStorage$2 = this.sessionStorage.get(DASHBOARD_STATE_SESSION_KEY)) === null || _this$sessionStorage$2 === void 0 ? void 0 : _this$sessionStorage$2[this.activeSpaceId]) !== null && _this$sessionStorage$ !== void 0 ? _this$sessionStorage$ : {};
      if (dashboardStateStorage[id]) {
        delete dashboardStateStorage[id];
        this.sessionStorage.set(DASHBOARD_STATE_SESSION_KEY, {
          [this.activeSpaceId]: dashboardStateStorage
        });
      }
    } catch (e) {
      _kibana_services.coreServices.notifications.toasts.addDanger({
        title: _i18n.i18n.translate('dashboard.panelStorageError.clearError', {
          defaultMessage: 'Error encountered while clearing unsaved changes: {message}',
          values: {
            message: e.message
          }
        }),
        'data-test-subj': 'dashboardPanelsClearFailure'
      });
    }
  }
  getSerializedPanelBackup(panelId, dashboardId = DASHBOARD_PANELS_UNSAVED_ID) {
    var _this$sessionStorage$3, _this$sessionStorage$4, _this$sessionStorage$5;
    return (_this$sessionStorage$3 = this.sessionStorage.get(DASHBOARD_SERIALIZED_PANEL_BACKUP_KEY)) === null || _this$sessionStorage$3 === void 0 ? void 0 : (_this$sessionStorage$4 = _this$sessionStorage$3[this.activeSpaceId]) === null || _this$sessionStorage$4 === void 0 ? void 0 : (_this$sessionStorage$5 = _this$sessionStorage$4[dashboardId]) === null || _this$sessionStorage$5 === void 0 ? void 0 : _this$sessionStorage$5[panelId];
  }
  setSerializedPanelsBackups(serializedPanels, dashboardId = DASHBOARD_PANELS_UNSAVED_ID) {
    try {
      var _this$sessionStorage$6;
      const serializedPanelsBackup = (_this$sessionStorage$6 = this.sessionStorage.get(DASHBOARD_SERIALIZED_PANEL_BACKUP_KEY)) !== null && _this$sessionStorage$6 !== void 0 ? _this$sessionStorage$6 : {};
      (0, _saferLodashSet.set)(serializedPanelsBackup, [this.activeSpaceId, dashboardId], serializedPanels);
      this.sessionStorage.set(DASHBOARD_SERIALIZED_PANEL_BACKUP_KEY, serializedPanelsBackup);
    } catch (e) {
      _kibana_services.coreServices.notifications.toasts.addDanger({
        title: _i18n.i18n.translate('dashboard.panelStorageError.setError', {
          defaultMessage: 'Error encountered while setting unsaved changes: {message}',
          values: {
            message: e.message
          }
        }),
        'data-test-subj': 'dashboardPanelsSetFailure'
      });
    }
  }
  getState(id = DASHBOARD_PANELS_UNSAVED_ID) {
    try {
      var _this$sessionStorage$7, _this$sessionStorage$8;
      return (_this$sessionStorage$7 = this.sessionStorage.get(DASHBOARD_STATE_SESSION_KEY)) === null || _this$sessionStorage$7 === void 0 ? void 0 : (_this$sessionStorage$8 = _this$sessionStorage$7[this.activeSpaceId]) === null || _this$sessionStorage$8 === void 0 ? void 0 : _this$sessionStorage$8[id];
    } catch (e) {
      _kibana_services.coreServices.notifications.toasts.addDanger({
        title: getPanelsGetError(e.message),
        'data-test-subj': 'dashboardPanelsGetFailure'
      });
    }
  }
  setState(id = DASHBOARD_PANELS_UNSAVED_ID, newState) {
    try {
      var _this$sessionStorage$9;
      const dashboardStateStorage = (_this$sessionStorage$9 = this.sessionStorage.get(DASHBOARD_STATE_SESSION_KEY)) !== null && _this$sessionStorage$9 !== void 0 ? _this$sessionStorage$9 : {};
      (0, _saferLodashSet.set)(dashboardStateStorage, [this.activeSpaceId, id], newState);
      this.sessionStorage.set(DASHBOARD_STATE_SESSION_KEY, dashboardStateStorage);
    } catch (e) {
      _kibana_services.coreServices.notifications.toasts.addDanger({
        title: _i18n.i18n.translate('dashboard.panelStorageError.setError', {
          defaultMessage: 'Error encountered while setting unsaved changes: {message}',
          values: {
            message: e.message
          }
        }),
        'data-test-subj': 'dashboardPanelsSetFailure'
      });
    }
  }
  getDashboardIdsWithUnsavedChanges() {
    try {
      var _this$sessionStorage$10, _this$sessionStorage$11;
      const dashboardStatesInSpace = (_this$sessionStorage$10 = (_this$sessionStorage$11 = this.sessionStorage.get(DASHBOARD_STATE_SESSION_KEY)) === null || _this$sessionStorage$11 === void 0 ? void 0 : _this$sessionStorage$11[this.activeSpaceId]) !== null && _this$sessionStorage$10 !== void 0 ? _this$sessionStorage$10 : {};
      const dashboardsSet = new Set();
      Object.keys(dashboardStatesInSpace).map(dashboardId => {
        if (dashboardStatesInSpace[dashboardId].viewMode === 'edit' && Object.keys(dashboardStatesInSpace[dashboardId]).some(stateKey => stateKey !== 'viewMode' && stateKey !== 'references')) {
          dashboardsSet.add(dashboardId);
        }
      });
      const dashboardsWithUnsavedChanges = [...dashboardsSet];

      /**
       * Because we are storing these unsaved dashboard IDs in React component state, we only want things to be re-rendered
       * if the **contents** change, not if the array reference changes
       */
      if (!(0, _lodash.isEqual)(this.oldDashboardsWithUnsavedChanges, dashboardsWithUnsavedChanges)) {
        this.oldDashboardsWithUnsavedChanges = dashboardsWithUnsavedChanges;
      }
      return this.oldDashboardsWithUnsavedChanges;
    } catch (e) {
      _kibana_services.coreServices.notifications.toasts.addDanger({
        title: getPanelsGetError(e.message),
        'data-test-subj': 'dashboardPanelsGetFailure'
      });
      return [];
    }
  }
  dashboardHasUnsavedEdits(id = DASHBOARD_PANELS_UNSAVED_ID) {
    return this.getDashboardIdsWithUnsavedChanges().indexOf(id) !== -1;
  }
}
let dashboardBackupService;
const getDashboardBackupService = () => {
  if (!dashboardBackupService) {
    dashboardBackupService = new DashboardBackupService();
  }
  return dashboardBackupService;
};
exports.getDashboardBackupService = getDashboardBackupService;