"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardGrid = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _coreRenderingBrowser = require("@kbn/core-rendering-browser");
var _gridLayout = require("@kbn/grid-layout");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _classnames = _interopRequireDefault(require("classnames"));
var _react2 = _interopRequireWildcard(require("react"));
var _constants = require("../../../common/content_management/constants");
var _layout_manager = require("../../dashboard_api/layout_manager");
var _use_dashboard_api = require("../../dashboard_api/use_dashboard_api");
var _use_dashboard_internal_api = require("../../dashboard_api/use_dashboard_internal_api");
var _constants2 = require("./constants");
var _dashboard_grid_item = require("./dashboard_grid_item");
var _use_layout_styles = require("./use_layout_styles");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DashboardGrid = ({
  dashboardContainerRef
}) => {
  const dashboardApi = (0, _use_dashboard_api.useDashboardApi)();
  const dashboardInternalApi = (0, _use_dashboard_internal_api.useDashboardInternalApi)();
  const layoutRef = (0, _react2.useRef)(null);
  const layoutStyles = (0, _use_layout_styles.useLayoutStyles)();
  const panelRefs = (0, _react2.useRef)({});
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [topOffset, setTopOffset] = (0, _react2.useState)(_constants2.DEFAULT_DASHBOARD_DRAG_TOP_OFFSET);
  const [expandedPanelId, layout, useMargins, viewMode] = (0, _presentationPublishing.useBatchedPublishingSubjects)(dashboardApi.expandedPanelId$, dashboardInternalApi.layout$, dashboardApi.settings.useMargins$, dashboardApi.viewMode$);
  (0, _react2.useEffect)(() => {
    var _dashboardContainerRe, _dashboardContainerRe2;
    setTopOffset((_dashboardContainerRe = dashboardContainerRef === null || dashboardContainerRef === void 0 ? void 0 : (_dashboardContainerRe2 = dashboardContainerRef.current) === null || _dashboardContainerRe2 === void 0 ? void 0 : _dashboardContainerRe2.getBoundingClientRect().top) !== null && _dashboardContainerRe !== void 0 ? _dashboardContainerRe : _constants2.DEFAULT_DASHBOARD_DRAG_TOP_OFFSET);
  }, [dashboardContainerRef]);
  const appFixedViewport = (0, _coreRenderingBrowser.useAppFixedViewport)();
  const currentLayout = (0, _react2.useMemo)(() => {
    const newLayout = {};
    Object.keys(layout.sections).forEach(sectionId => {
      const section = layout.sections[sectionId];
      newLayout[sectionId] = {
        id: sectionId,
        type: 'section',
        row: section.gridData.y,
        isCollapsed: Boolean(section.collapsed),
        title: section.title,
        panels: {}
      };
    });
    Object.keys(layout.panels).forEach(panelId => {
      const gridData = layout.panels[panelId].gridData;
      const basePanel = {
        id: panelId,
        row: gridData.y,
        column: gridData.x,
        width: gridData.w,
        height: gridData.h
      };
      if (gridData.sectionId) {
        newLayout[gridData.sectionId].panels[panelId] = basePanel;
      } else {
        newLayout[panelId] = {
          ...basePanel,
          type: 'panel'
        };
      }
      // update `data-grid-row` attribute for all panels because it is used for some styling
      const panelRef = panelRefs.current[panelId];
      if (typeof panelRef !== 'function' && panelRef !== null && panelRef !== void 0 && panelRef.current) {
        panelRef.current.setAttribute('data-grid-row', `${gridData.y}`);
      }
    });
    return newLayout;
  }, [layout]);
  const onLayoutChange = (0, _react2.useCallback)(newLayout => {
    if (viewMode !== 'edit') return;
    const currLayout = dashboardInternalApi.layout$.getValue();
    const updatedLayout = {
      sections: {},
      panels: {}
    };
    Object.values(newLayout).forEach(widget => {
      if (widget.type === 'section') {
        updatedLayout.sections[widget.id] = {
          collapsed: widget.isCollapsed,
          title: widget.title,
          gridData: {
            i: widget.id,
            y: widget.row
          }
        };
        Object.values(widget.panels).forEach(panel => {
          updatedLayout.panels[panel.id] = {
            ...currLayout.panels[panel.id],
            gridData: {
              ...convertGridPanelToDashboardGridData(panel),
              sectionId: widget.id
            }
          };
        });
      } else {
        // widget is a panel
        updatedLayout.panels[widget.id] = {
          ...currLayout.panels[widget.id],
          gridData: convertGridPanelToDashboardGridData(widget)
        };
      }
    });
    if (!(0, _layout_manager.areLayoutsEqual)(currLayout, updatedLayout)) {
      dashboardInternalApi.layout$.next(updatedLayout);
    }
  }, [dashboardInternalApi.layout$, viewMode]);
  const renderPanelContents = (0, _react2.useCallback)((id, setDragHandles) => {
    const panels = dashboardInternalApi.layout$.getValue().panels;
    if (!panels[id]) return;
    if (!panelRefs.current[id]) {
      panelRefs.current[id] = /*#__PURE__*/_react2.default.createRef();
    }
    const type = panels[id].type;
    return /*#__PURE__*/_react2.default.createElement(_dashboard_grid_item.DashboardGridItem, {
      ref: panelRefs.current[id],
      key: id,
      id: id,
      type: type,
      setDragHandles: setDragHandles,
      appFixedViewport: appFixedViewport,
      dashboardContainerRef: dashboardContainerRef,
      "data-grid-row": panels[id].gridData.y // initialize data-grid-row
    });
  }, [appFixedViewport, dashboardContainerRef, dashboardInternalApi.layout$]);
  (0, _react2.useEffect)(() => {
    /**
     * ResizeObserver fires the callback on `.observe()` with the initial size of the observed
     * element; we want to ignore this first call and scroll to the bottom on the **second**
     * callback - i.e. after the row is actually added to the DOM
     */
    let first = false;
    const scrollToBottomOnResize = new ResizeObserver(() => {
      if (first) {
        first = false;
      } else {
        dashboardApi.scrollToBottom();
        scrollToBottomOnResize.disconnect(); // once scrolled, stop observing resize events
      }
    });

    /**
     * When `scrollToBottom$` emits, wait for the `layoutRef` size to change then scroll
     * to the bottom of the screen
     */
    const scrollToBottomSubscription = dashboardApi.scrollToBottom$.subscribe(() => {
      if (!layoutRef.current) return;
      first = true; // ensure that only the second resize callback actually triggers scrolling
      scrollToBottomOnResize.observe(layoutRef.current);
    });
    return () => {
      scrollToBottomOnResize.disconnect();
      scrollToBottomSubscription.unsubscribe();
    };
  }, [dashboardApi]);
  const memoizedgridLayout = (0, _react2.useMemo)(() => {
    // memoizing this component reduces the number of times it gets re-rendered to a minimum
    return /*#__PURE__*/_react2.default.createElement(_gridLayout.GridLayout, {
      css: layoutStyles,
      layout: currentLayout,
      gridSettings: {
        gutterSize: useMargins ? _constants2.DASHBOARD_MARGIN_SIZE : 0,
        rowHeight: _constants2.DASHBOARD_GRID_HEIGHT,
        columnCount: _constants.DASHBOARD_GRID_COLUMN_COUNT,
        keyboardDragTopLimit: topOffset
      },
      useCustomDragHandle: true,
      renderPanelContents: renderPanelContents,
      onLayoutChange: onLayoutChange,
      expandedPanelId: expandedPanelId,
      accessMode: viewMode === 'edit' ? 'EDIT' : 'VIEW'
    });
  }, [layoutStyles, currentLayout, useMargins, renderPanelContents, onLayoutChange, expandedPanelId, viewMode, topOffset]);
  const {
    dashboardClasses,
    dashboardStyles
  } = (0, _react2.useMemo)(() => {
    return {
      dashboardClasses: (0, _classnames.default)({
        'dshLayout-withoutMargins': !useMargins,
        'dshLayout--viewing': viewMode === 'view',
        'dshLayout--editing': viewMode !== 'view',
        'dshLayout-isMaximizedPanel': expandedPanelId !== undefined
      }),
      dashboardStyles: (0, _react.css)`
        // for dashboards with no controls, increase the z-index of the hover actions in the
        // top row so that they overlap the sticky nav in Dashboard
        .dshDashboardViewportWrapper:not(:has(.dshDashboardViewport-controls))
          &
          .dshDashboardGrid__item[data-grid-row='0']
          .embPanel__hoverActions {
          z-index: ${euiTheme.levels.toast};
        }

        // when in fullscreen mode, combine all floating actions on first row and nudge them down
      `
    };
  }, [useMargins, viewMode, expandedPanelId, euiTheme.levels.toast]);
  return /*#__PURE__*/_react2.default.createElement("div", {
    ref: layoutRef,
    className: dashboardClasses,
    css: dashboardStyles
  }, memoizedgridLayout);
};
exports.DashboardGrid = DashboardGrid;
const convertGridPanelToDashboardGridData = panel => {
  return {
    i: panel.id,
    y: panel.row,
    x: panel.column,
    w: panel.width,
    h: panel.height
  };
};