"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExportCSVAction = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/data-plugin/public");
var _public2 = require("@kbn/share-plugin/public");
var _public3 = require("@kbn/ui-actions-plugin/public");
var _public4 = require("@kbn/inspector-plugin/public");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _kibana_services = require("../services/kibana_services");
var _dashboard_actions_strings = require("./_dashboard_actions_strings");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const isApiCompatible = api => Boolean((0, _public4.apiHasInspectorAdapters)(api));
class ExportCSVAction {
  constructor() {
    (0, _defineProperty2.default)(this, "id", _constants.ACTION_EXPORT_CSV);
    (0, _defineProperty2.default)(this, "type", _constants.ACTION_EXPORT_CSV);
    (0, _defineProperty2.default)(this, "order", 18);
    (0, _defineProperty2.default)(this, "getDisplayName", context => _dashboard_actions_strings.dashboardExportCsvActionStrings.getDisplayName());
    (0, _defineProperty2.default)(this, "hasDatatableContent", adapters => {
      return Object.keys((adapters === null || adapters === void 0 ? void 0 : adapters.tables) || {}).length > 0 && adapters.tables.allowCsvExport;
    });
    (0, _defineProperty2.default)(this, "getFormatter", () => {
      return _kibana_services.fieldFormatService.deserialize;
    });
    (0, _defineProperty2.default)(this, "getDataTableContent", adapters => {
      if (this.hasDatatableContent(adapters)) {
        return adapters === null || adapters === void 0 ? void 0 : adapters.tables.tables;
      }
      return;
    });
    (0, _defineProperty2.default)(this, "exportCSV", async (embeddable, asString = false) => {
      const formatFactory = this.getFormatter();
      // early exit if not formatter is available
      if (!formatFactory) {
        return;
      }
      const tableAdapters = this.getDataTableContent(embeddable === null || embeddable === void 0 ? void 0 : embeddable.getInspectorAdapters());
      if (tableAdapters) {
        const datatables = Object.values(tableAdapters);
        const content = datatables.reduce((memo, datatable, i) => {
          // skip empty datatables
          if (datatable) {
            const postFix = datatables.length > 1 ? `-${i + 1}` : '';
            const untitledFilename = _dashboard_actions_strings.dashboardExportCsvActionStrings.getUntitledFilename();
            memo[`${(0, _presentationPublishing.getTitle)(embeddable) || untitledFilename}${postFix}.csv`] = {
              content: _public.exporters.datatableToCSV(datatable, {
                csvSeparator: _kibana_services.coreServices.uiSettings.get('csv:separator', ','),
                quoteValues: _kibana_services.coreServices.uiSettings.get('csv:quoteValues', true),
                formatFactory,
                escapeFormulaValues: false
              }),
              type: _public.exporters.CSV_MIME_TYPE
            };
          }
          return memo;
        }, {});

        // useful for testing
        if (asString) {
          return content;
        }
        if (content) {
          return (0, _public2.downloadMultipleAs)(content);
        }
      }
    });
  }
  getIconType() {
    return 'exportAction';
  }
  async isCompatible({
    embeddable
  }) {
    var _embeddable$getInspec;
    if (!isApiCompatible(embeddable)) return false;
    return Boolean(this.hasDatatableContent(embeddable === null || embeddable === void 0 ? void 0 : (_embeddable$getInspec = embeddable.getInspectorAdapters) === null || _embeddable$getInspec === void 0 ? void 0 : _embeddable$getInspec.call(embeddable)));
  }
  async execute({
    embeddable,
    asString
  }) {
    if (!isApiCompatible(embeddable)) throw new _public3.IncompatibleActionError();
    return await this.exportCSV(embeddable, asString);
  }
}
exports.ExportCSVAction = ExportCSVAction;