"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.executeAddLensPanelAction = executeAddLensPanelAction;
var _public = require("@kbn/ui-actions-plugin/public");
var _i18n = require("@kbn/i18n");
var _kibana_services = require("../services/kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function executeAddLensPanelAction(dashboardApi) {
  try {
    const addLensPanelAction = await _kibana_services.uiActionsService.getAction('addLensPanelAction');
    addLensPanelAction.execute({
      embeddable: dashboardApi,
      trigger: _public.addPanelMenuTrigger
    });
  } catch (error) {
    _kibana_services.coreServices.notifications.toasts.addWarning(_i18n.i18n.translate('dashboard.addNewPanelError', {
      defaultMessage: 'Unable to add new panel'
    }));
  }
}