"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.prepareModelVersionTestKit = void 0;
var _promises = _interopRequireDefault(require("fs/promises"));
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _config = require("@kbn/config");
var _configMocks = require("@kbn/config-mocks");
var _repoInfo = require("@kbn/repo-info");
var _coreSavedObjectsMigrationServerInternal = require("@kbn/core-saved-objects-migration-server-internal");
var _coreSavedObjectsBaseServerInternal = require("@kbn/core-saved-objects-base-server-internal");
var _coreSavedObjectsApiServerInternal = require("@kbn/core-saved-objects-api-server-internal");
var _coreElasticsearchServerInternal = require("@kbn/core-elasticsearch-server-internal");
var _coreElasticsearchClientServerInternal = require("@kbn/core-elasticsearch-client-server-internal");
var _coreLoggingServerInternal = require("@kbn/core-logging-server-internal");
var _test = require("@kbn/test");
var _coreRootServerInternal = require("@kbn/core-root-server-internal");
var _docLinks = require("@kbn/doc-links");
var _type_registry = require("./type_registry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const env = _config.Env.createDefault(_repoInfo.REPO_ROOT, (0, _configMocks.getEnvOptions)());
const currentVersion = env.packageInfo.version;
const currentBranch = env.packageInfo.branch;
const defaultKibanaIndex = '.kibana_migrator_tests';
const defaultNodeRoles = {
  migrator: true,
  ui: true,
  backgroundTasks: true
};

/**
 * Prepare the model version integration test kit
 *
 * @internal
 */
const prepareModelVersionTestKit = async ({
  savedObjectDefinitions,
  objectsToCreateBetween = [],
  settingOverrides = {},
  kibanaBranch = currentBranch,
  kibanaVersion = currentVersion,
  kibanaIndex = defaultKibanaIndex,
  logFilePath
}) => {
  await _promises.default.unlink(logFilePath).catch(() => {});
  const loggingSystem = new _coreLoggingServerInternal.LoggingSystem();
  const loggerFactory = loggingSystem.asLoggerFactory();
  const configService = getConfigService(settingOverrides, loggerFactory, logFilePath);

  // configure logging system
  const loggingConf = await (0, _rxjs.firstValueFrom)(configService.atPath('logging'));
  await loggingSystem.upgrade(loggingConf);
  const esClient = await getElasticsearchClient(configService, loggerFactory, kibanaVersion);
  const {
    registryBefore,
    registryAfter
  } = (0, _type_registry.getTypeRegistries)({
    types: savedObjectDefinitions,
    kibanaIndex
  });
  const commonMigratorParams = {
    configService,
    client: esClient,
    loggerFactory,
    kibanaIndex,
    defaultIndexTypesMap: {},
    hashToVersionMap: {},
    kibanaVersion,
    kibanaBranch,
    nodeRoles: defaultNodeRoles
  };
  const firstMigrator = await getMigrator({
    ...commonMigratorParams,
    typeRegistry: registryBefore
  });
  const secondMigrator = await getMigrator({
    ...commonMigratorParams,
    typeRegistry: registryAfter
  });
  const repositoryBefore = _coreSavedObjectsApiServerInternal.SavedObjectsRepository.createRepository(firstMigrator, registryBefore, kibanaIndex, esClient, loggerFactory.get('saved_objects'));
  const repositoryAfter = _coreSavedObjectsApiServerInternal.SavedObjectsRepository.createRepository(secondMigrator, registryAfter, kibanaIndex, esClient, loggerFactory.get('saved_objects'));
  await runMigrations(firstMigrator);
  if (objectsToCreateBetween.length) {
    await repositoryBefore.bulkCreate(objectsToCreateBetween, {
      refresh: 'wait_for'
    });
  }
  await runMigrations(secondMigrator);
  const tearDown = async () => {
    await esClient.indices.delete({
      index: `${kibanaIndex}_*`,
      allow_no_indices: true
    });
  };
  return {
    esClient,
    repositoryBefore,
    repositoryAfter,
    tearDown
  };
};
exports.prepareModelVersionTestKit = prepareModelVersionTestKit;
const getConfigService = (settings, loggerFactory, logFilePath) => {
  // Define some basic default kibana settings
  const DEFAULTS_SETTINGS = {
    server: {
      autoListen: true,
      // Use the ephemeral port to make sure that tests use the first available
      // port and aren't affected by the timing issues in test environment.
      port: 0,
      xsrf: {
        disableProtection: true
      }
    },
    elasticsearch: {
      hosts: [_test.esTestConfig.getUrl()],
      username: _test.kibanaServerTestUser.username,
      password: _test.kibanaServerTestUser.password
    },
    migrations: {
      algorithm: 'v2',
      skip: false
    },
    logging: {
      appenders: {
        file: {
          type: 'file',
          fileName: logFilePath,
          layout: {
            type: 'json'
          }
        }
      },
      loggers: [{
        name: 'root',
        level: 'info',
        appenders: ['file']
      }]
    },
    plugins: {}
  };
  const rawConfigProvider = {
    getConfig$: () => new _rxjs.BehaviorSubject((0, _lodash.defaultsDeep)({}, settings, DEFAULTS_SETTINGS))
  };
  const configService = new _config.ConfigService(rawConfigProvider, env, loggerFactory);
  (0, _coreRootServerInternal.registerServiceConfig)(configService);
  return configService;
};
const getElasticsearchClient = async (configService, loggerFactory, kibanaVersion) => {
  var _esClientConfig$dnsCa, _esClientConfig$dnsCa2;
  const esClientConfig = await (0, _rxjs.firstValueFrom)(configService.atPath('elasticsearch').pipe((0, _rxjs.map)(rawConfig => new _coreElasticsearchServerInternal.ElasticsearchConfig(rawConfig))));
  return (0, _coreElasticsearchClientServerInternal.configureClient)(esClientConfig, {
    logger: loggerFactory.get('elasticsearch'),
    type: 'data',
    agentFactoryProvider: new _coreElasticsearchClientServerInternal.AgentManager(loggerFactory.get('elasticsearch-service', 'agent-manager'), {
      dnsCacheTtlInSeconds: (_esClientConfig$dnsCa = (_esClientConfig$dnsCa2 = esClientConfig.dnsCacheTtl) === null || _esClientConfig$dnsCa2 === void 0 ? void 0 : _esClientConfig$dnsCa2.asSeconds()) !== null && _esClientConfig$dnsCa !== void 0 ? _esClientConfig$dnsCa : 0
    }),
    kibanaVersion
  });
};
const getMigrator = async ({
  configService,
  client,
  kibanaIndex,
  typeRegistry,
  defaultIndexTypesMap,
  hashToVersionMap,
  loggerFactory,
  kibanaVersion,
  kibanaBranch,
  buildFlavor = 'traditional',
  nodeRoles
}) => {
  const savedObjectsConf = await (0, _rxjs.firstValueFrom)(configService.atPath('savedObjects'));
  const savedObjectsMigrationConf = await (0, _rxjs.firstValueFrom)(configService.atPath('migrations'));
  const soConfig = new _coreSavedObjectsBaseServerInternal.SavedObjectConfig(savedObjectsConf, savedObjectsMigrationConf);
  const docLinks = {
    ...(0, _docLinks.getDocLinksMeta)({
      kibanaBranch,
      buildFlavor
    }),
    links: (0, _docLinks.getDocLinks)({
      kibanaBranch,
      buildFlavor
    })
  };
  const esCapabilities = await (0, _coreElasticsearchServerInternal.getCapabilitiesFromClient)(client);
  return new _coreSavedObjectsMigrationServerInternal.KibanaMigrator({
    client,
    kibanaIndex,
    typeRegistry,
    defaultIndexTypesMap,
    hashToVersionMap,
    soMigrationsConfig: soConfig.migration,
    kibanaVersion,
    logger: loggerFactory.get('savedobjects-service'),
    docLinks,
    waitForMigrationCompletion: false,
    // ensure we have an active role in the migration
    nodeRoles,
    esCapabilities
  });
};
const runMigrations = async migrator => {
  migrator.prepareMigrations();
  await migrator.runMigrations();
};