"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.startElasticsearch = void 0;
var _coreTestHelpersKbnServer = require("@kbn/core-test-helpers-kbn-server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Start the traditional ES cluster and return the instance.
 */
const startElasticsearch = async ({
  basePath,
  dataArchive,
  timeout
} = {}) => {
  const {
    startES
  } = (0, _coreTestHelpersKbnServer.createTestServers)({
    adjustTimeout: t => jest.setTimeout(t + (timeout !== null && timeout !== void 0 ? timeout : 0)),
    settings: {
      es: {
        license: 'basic',
        basePath,
        dataArchive
      }
    }
  });
  return await startES();
};
exports.startElasticsearch = startElasticsearch;