"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultUserProfileImplementation = void 0;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getDefaultUserProfileImplementation = () => {
  return {
    userProfile$: (0, _rxjs.of)(null),
    enabled$: (0, _rxjs.of)(false),
    getCurrent: () => Promise.resolve(null),
    bulkGet: () => Promise.resolve([]),
    suggest: () => Promise.resolve([]),
    update: () => Promise.resolve(),
    partialUpdate: () => Promise.resolve()
  };
};
exports.getDefaultUserProfileImplementation = getDefaultUserProfileImplementation;