"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThemeService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _uiTheme = require("@kbn/ui-theme");
var _system_theme = require("./system_theme");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/** @internal */

/** @internal */
class ThemeService {
  constructor() {
    (0, _defineProperty2.default)(this, "contract", void 0);
    (0, _defineProperty2.default)(this, "themeMetadata", void 0);
    (0, _defineProperty2.default)(this, "stylesheets", []);
  }
  setup({
    injectedMetadata
  }) {
    const themeMetadata = injectedMetadata.getTheme();
    this.themeMetadata = themeMetadata;
    let theme;
    if (themeMetadata.darkMode === 'system' && (0, _system_theme.browsersSupportsSystemTheme)()) {
      theme = {
        darkMode: (0, _system_theme.systemThemeIsDark)()
      };
    } else {
      const darkMode = themeMetadata.darkMode === 'system' ? false : themeMetadata.darkMode;
      theme = {
        darkMode
      };
    }
    this.applyTheme(theme);
    this.contract = {
      getTheme: () => theme,
      theme$: (0, _rxjs.of)(theme)
    };
    return this.contract;
  }
  start() {
    if (!this.contract) {
      throw new Error('setup must be called before start');
    }
    return this.contract;
  }
  stop() {}
  applyTheme(theme) {
    const {
      darkMode
    } = theme;
    this.stylesheets.forEach(stylesheet => {
      stylesheet.remove();
    });
    this.stylesheets = [];
    const newStylesheets = darkMode ? this.themeMetadata.stylesheetPaths.dark : this.themeMetadata.stylesheetPaths.default;
    newStylesheets.forEach(stylesheet => {
      this.stylesheets.push((0, _utils.createStyleSheet)({
        href: stylesheet
      }));
    });
    (0, _uiTheme._setDarkMode)(darkMode);
    updateKbnThemeTag(darkMode);
  }
}
exports.ThemeService = ThemeService;
const updateKbnThemeTag = darkMode => {
  const globals = typeof window === 'undefined' ? {} : window;
  globals.__kbnThemeTag__ = darkMode ? 'v8dark' : 'v8light';
};