"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BrowserLoggingSystem = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _logging = require("@kbn/logging");
var _coreLoggingCommonInternal = require("@kbn/core-logging-common-internal");
var _logger = require("./logger");
var _layouts = require("./layouts");
var _appenders = require("./appenders");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const CONSOLE_APPENDER_ID = 'console';

/**
 * @internal
 */

/**
 * @internal
 */
class BrowserLoggingSystem {
  constructor(loggingConfig) {
    (0, _defineProperty2.default)(this, "computedConfig", void 0);
    (0, _defineProperty2.default)(this, "loggers", new Map());
    (0, _defineProperty2.default)(this, "appenders", new Map());
    this.computedConfig = this.setupSystem(loggingConfig);
  }
  get(...contextParts) {
    const context = (0, _coreLoggingCommonInternal.getLoggerContext)(contextParts);
    if (!this.loggers.has(context)) {
      this.loggers.set(context, this.createLogger(context));
    }
    return this.loggers.get(context);
  }
  createLogger(context) {
    const {
      level,
      appenders
    } = this.getLoggerConfigByContext(context);
    const loggerLevel = _logging.LogLevel.fromId(level);
    const loggerAppenders = appenders.map(appenderKey => this.appenders.get(appenderKey));
    return new _logger.BaseLogger(context, loggerLevel, loggerAppenders, this.asLoggerFactory());
  }
  getLoggerConfigByContext(context) {
    const loggerConfig = this.computedConfig.loggers.get(context);
    if (loggerConfig !== undefined) {
      return {
        name: loggerConfig.name,
        level: loggerConfig.level,
        appenders: [CONSOLE_APPENDER_ID]
      };
    }

    // If we don't have configuration for the specified context, we move up to the parent context, up to `root`
    return this.getLoggerConfigByContext((0, _coreLoggingCommonInternal.getParentLoggerContext)(context));
  }
  setupSystem(loggingConfig) {
    const consoleAppender = new _appenders.ConsoleAppender(new _layouts.PatternLayout());
    this.appenders.set(CONSOLE_APPENDER_ID, consoleAppender);
    const loggerConfigs = loggingConfig.loggers.reduce((loggers, logger) => {
      loggers.set(logger.name, logger);
      return loggers;
    }, new Map());
    loggerConfigs.set(_coreLoggingCommonInternal.ROOT_CONTEXT_NAME, {
      name: _coreLoggingCommonInternal.ROOT_CONTEXT_NAME,
      ...loggingConfig.root
    });
    return {
      loggers: loggerConfigs
    };
  }

  /**
   * Safe wrapper that allows passing logging service as immutable LoggerFactory.
   */
  asLoggerFactory() {
    return {
      get: (...contextParts) => this.get(...contextParts)
    };
  }
}
exports.BrowserLoggingSystem = BrowserLoggingSystem;