"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BasePath = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _std = require("@kbn/std");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class BasePath {
  constructor({
    basePath,
    serverBasePath,
    assetsHrefBase,
    publicBaseUrl
  }) {
    (0, _defineProperty2.default)(this, "basePath", void 0);
    (0, _defineProperty2.default)(this, "serverBasePath", void 0);
    (0, _defineProperty2.default)(this, "assetsHrefBase", void 0);
    (0, _defineProperty2.default)(this, "publicBaseUrl", void 0);
    (0, _defineProperty2.default)(this, "get", () => {
      return this.basePath;
    });
    (0, _defineProperty2.default)(this, "prepend", path => {
      if (!this.basePath) {
        return path;
      }
      return (0, _std.modifyUrl)(path, parts => {
        if (!parts.hostname && parts.pathname && parts.pathname.startsWith('/')) {
          parts.pathname = `${this.basePath}${parts.pathname}`;
        }
      });
    });
    (0, _defineProperty2.default)(this, "remove", path => {
      if (!this.basePath) {
        return path;
      }
      if (path === this.basePath) {
        return '/';
      }
      if (path.startsWith(`${this.basePath}/`)) {
        return path.slice(this.basePath.length);
      }
      return path;
    });
    this.basePath = basePath;
    this.serverBasePath = serverBasePath !== null && serverBasePath !== void 0 ? serverBasePath : this.basePath;
    this.assetsHrefBase = assetsHrefBase !== null && assetsHrefBase !== void 0 ? assetsHrefBase : this.serverBasePath;
    this.publicBaseUrl = publicBaseUrl;
  }
}
exports.BasePath = BasePath;