"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnonymousPathsService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class AnonymousPathsService {
  constructor() {
    (0, _defineProperty2.default)(this, "paths", new Set());
  }
  setup({
    basePath
  }) {
    return {
      isAnonymous: path => {
        const pathWithoutBasePath = basePath.remove(path);
        return this.paths.has(normalizePath(pathWithoutBasePath));
      },
      register: path => {
        this.paths.add(normalizePath(path));
      },
      normalizePath
    };
  }
  start(deps) {
    return this.setup(deps);
  }
  stop() {}
}
exports.AnonymousPathsService = AnonymousPathsService;
const normalizePath = path => {
  // always lower-case it
  let normalized = path.toLowerCase();

  // remove the slash from the end
  if (normalized.endsWith('/')) {
    normalized = normalized.slice(0, normalized.length - 1);
  }

  // put a slash at the start
  if (!normalized.startsWith('/')) {
    normalized = `/${normalized}`;
  }

  // it's normalized!!!
  return normalized;
};