"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FatalErrorsScreen = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _rxjs = require("rxjs");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class FatalErrorsScreen extends _react.default.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      errors: []
    });
    (0, _defineProperty2.default)(this, "subscription", void 0);
    (0, _defineProperty2.default)(this, "onClickGoBack", e => {
      e.preventDefault();
      window.history.back();
    });
    (0, _defineProperty2.default)(this, "onClickClearSession", e => {
      e.preventDefault();
      localStorage.clear();
      sessionStorage.clear();
      window.location.hash = '';
      window.location.reload();
    });
  }
  componentDidMount() {
    this.subscription = (0, _rxjs.merge)(
    // reload the page if hash-based navigation is attempted
    (0, _rxjs.fromEvent)(window, 'hashchange').pipe((0, _rxjs.tap)(() => {
      window.location.reload();
    })),
    // consume error notifications and set them to the component state
    this.props.errorInfo$.pipe((0, _rxjs.tap)(error => {
      this.setState(state => ({
        ...state,
        errors: [...state.errors, error]
      }));
    }))).subscribe({
      error(error) {
        // eslint-disable-next-line no-console
        console.error('Uncaught error in fatal error screen internals', error);
      }
    });
  }
  componentWillUnmount() {
    if (this.subscription) {
      this.subscription.unsubscribe();
      this.subscription = undefined;
    }
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, {
      style: {
        minHeight: '100vh',
        alignItems: 'center'
      },
      "data-test-subj": "fatalErrorScreen"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
      alignment: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "warning",
      iconColor: "danger",
      title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "core.fatalErrors.somethingWentWrongTitle",
        defaultMessage: "Something went wrong"
      })),
      body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "core.fatalErrors.tryRefreshingPageDescription",
        defaultMessage: "Try refreshing the page. If that doesn't work, go back to the previous page or clear your session data."
      })),
      actions: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        color: "primary",
        fill: true,
        onClick: this.onClickClearSession,
        "data-test-subj": "clearSession"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "core.fatalErrors.clearYourSessionButtonLabel",
        defaultMessage: "Clear your session"
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        onClick: this.onClickGoBack,
        "data-test-subj": "goBack"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "core.fatalErrors.goBackButtonLabel",
        defaultMessage: "Go back"
      }))]
    }), this.state.errors.map((error, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      key: i,
      title: error.message,
      color: "danger",
      iconType: "warning"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "bash",
      className: "eui-textBreakAll"
    }, `Version: ${this.props.kibanaVersion}` + '\n' + `Build: ${this.props.buildNumber}` + '\n' + (error.stack ? error.stack : '')))))));
  }
}
exports.FatalErrorsScreen = FatalErrorsScreen;