"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIsRouteApiDeprecation = exports.buildApiRouteDeprecationDetails = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
var _i18n_texts = require("./i18n_texts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getIsRouteApiDeprecation = ({
  isInternalApiRequest,
  deprecated
}) => {
  const hasDeprecatedObject = deprecated && _lodash.default.isObject(deprecated);
  const isNotInternalRequest = !isInternalApiRequest;
  return !!(hasDeprecatedObject && isNotInternalRequest);
};
exports.getIsRouteApiDeprecation = getIsRouteApiDeprecation;
const buildApiRouteDeprecationDetails = ({
  apiUsageStats,
  deprecatedApiDetails,
  docLinks
}) => {
  const {
    apiId,
    apiTotalCalls,
    totalMarkedAsResolved
  } = apiUsageStats;
  const {
    routeVersion,
    routePath,
    routeDeprecationOptions,
    routeMethod
  } = deprecatedApiDetails;
  if (!routeDeprecationOptions) {
    throw new Error(`Expecing deprecated to be defined for route ${apiId}`);
  }
  const deprecationLevel = routeDeprecationOptions.severity || 'warning';
  return {
    apiId,
    title: (0, _i18n_texts.getApiDeprecationTitle)(deprecatedApiDetails),
    level: deprecationLevel,
    message: (0, _i18n_texts.getApiDeprecationMessage)(deprecatedApiDetails, apiUsageStats, docLinks),
    documentationUrl: routeDeprecationOptions.documentationUrl,
    correctiveActions: {
      manualSteps: (0, _i18n_texts.getApiDeprecationsManualSteps)(deprecatedApiDetails),
      mark_as_resolved_api: {
        routePath,
        routeMethod,
        routeVersion,
        apiTotalCalls,
        totalMarkedAsResolved,
        timestamp: new Date()
      }
    },
    deprecationType: 'api',
    domainId: 'core.http.routes-deprecations'
  };
};
exports.buildApiRouteDeprecationDetails = buildApiRouteDeprecationDetails;