"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusApp = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _lib = require("./lib");
var _components = require("./components");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class StatusApp extends _react.Component {
  constructor(props) {
    super(props);
    this.state = {
      loading: true,
      fetchError: false,
      data: null
    };
  }
  async componentDidMount() {
    const {
      http,
      notifications
    } = this.props;
    try {
      const data = await (0, _lib.loadStatus)({
        http,
        notifications
      });
      this.setState({
        loading: false,
        fetchError: false,
        data
      });
    } catch (e) {
      this.setState({
        fetchError: true,
        loading: false,
        data: null
      });
    }
  }
  render() {
    const {
      loading,
      fetchError,
      data
    } = this.state;

    // If we're still loading, return early with a spinner
    if (loading) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "l"
      });
    }
    if (fetchError) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "danger"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "core.statusPage.statusApp.loadingErrorText",
        defaultMessage: "An error occurred loading the status"
      }));
    }
    const {
      metrics,
      coreStatus,
      pluginStatus,
      serverState,
      name,
      version
    } = data;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, {
      className: "stsPage",
      "data-test-subj": "statusPageRoot"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
      restrictWidth: true
    }, /*#__PURE__*/_react.default.createElement(_components.ServerStatus, {
      name: name,
      serverState: serverState
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_components.VersionHeader, {
      version: version
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_components.MetricTiles, {
      metrics: metrics
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_components.StatusSection, {
      id: "core",
      title: _i18n.i18n.translate('core.statusPage.coreStatus.sectionTitle', {
        defaultMessage: 'Core status'
      }),
      statuses: coreStatus
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_components.StatusSection, {
      id: "plugins",
      title: _i18n.i18n.translate('core.statusPage.statusApp.statusTitle', {
        defaultMessage: 'Plugin status'
      }),
      statuses: pluginStatus
    })));
  }
}
exports.StatusApp = StatusApp;