"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.USAGE_COUNTERS_SAVED_OBJECT_INDEX = exports.TASK_MANAGER_SAVED_OBJECT_INDEX = exports.SECURITY_SOLUTION_SAVED_OBJECT_INDEX = exports.MAIN_SAVED_OBJECT_INDEX = exports.INGEST_SAVED_OBJECT_INDEX = exports.ANALYTICS_SAVED_OBJECT_INDEX = exports.ALL_SAVED_OBJECT_INDICES = exports.ALERTING_CASES_SAVED_OBJECT_INDEX = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Collect and centralize the names of the different saved object indices.
 * Note that all of them start with the '.kibana' prefix.
 * There are multiple places in the code that these indices have the form .kibana*.
 * However, beware that there are some system indices that have the same prefix
 * but are NOT used to store saved objects, e.g.: .kibana_security_session_1
 */
const MAIN_SAVED_OBJECT_INDEX = exports.MAIN_SAVED_OBJECT_INDEX = '.kibana';
const TASK_MANAGER_SAVED_OBJECT_INDEX = exports.TASK_MANAGER_SAVED_OBJECT_INDEX = `${MAIN_SAVED_OBJECT_INDEX}_task_manager`;
const INGEST_SAVED_OBJECT_INDEX = exports.INGEST_SAVED_OBJECT_INDEX = `${MAIN_SAVED_OBJECT_INDEX}_ingest`;
const ALERTING_CASES_SAVED_OBJECT_INDEX = exports.ALERTING_CASES_SAVED_OBJECT_INDEX = `${MAIN_SAVED_OBJECT_INDEX}_alerting_cases`;
const SECURITY_SOLUTION_SAVED_OBJECT_INDEX = exports.SECURITY_SOLUTION_SAVED_OBJECT_INDEX = `${MAIN_SAVED_OBJECT_INDEX}_security_solution`;
const ANALYTICS_SAVED_OBJECT_INDEX = exports.ANALYTICS_SAVED_OBJECT_INDEX = `${MAIN_SAVED_OBJECT_INDEX}_analytics`;
const USAGE_COUNTERS_SAVED_OBJECT_INDEX = exports.USAGE_COUNTERS_SAVED_OBJECT_INDEX = `${MAIN_SAVED_OBJECT_INDEX}_usage_counters`;
const ALL_SAVED_OBJECT_INDICES = exports.ALL_SAVED_OBJECT_INDICES = [MAIN_SAVED_OBJECT_INDEX, TASK_MANAGER_SAVED_OBJECT_INDEX, ALERTING_CASES_SAVED_OBJECT_INDEX, INGEST_SAVED_OBJECT_INDEX, SECURITY_SOLUTION_SAVED_OBJECT_INDEX, ANALYTICS_SAVED_OBJECT_INDEX, USAGE_COUNTERS_SAVED_OBJECT_INDEX];