"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIsAccessApiDeprecation = exports.buildApiAccessDeprecationDetails = void 0;
var _i18n_texts = require("./i18n_texts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getIsAccessApiDeprecation = ({
  isInternalApiRequest,
  isPublicAccess
}) => {
  const isNotPublicAccess = !isPublicAccess;
  const isNotInternalRequest = !isInternalApiRequest;
  return !!(isNotPublicAccess && isNotInternalRequest);
};
exports.getIsAccessApiDeprecation = getIsAccessApiDeprecation;
const buildApiAccessDeprecationDetails = ({
  apiUsageStats,
  deprecatedApiDetails,
  docLinks
}) => {
  const {
    apiId,
    apiTotalCalls,
    totalMarkedAsResolved
  } = apiUsageStats;
  const {
    routeVersion,
    routePath,
    routeDeprecationOptions,
    routeMethod
  } = deprecatedApiDetails;
  const deprecationLevel = (routeDeprecationOptions === null || routeDeprecationOptions === void 0 ? void 0 : routeDeprecationOptions.severity) || 'warning';
  return {
    apiId,
    title: (0, _i18n_texts.getApiDeprecationTitle)(deprecatedApiDetails),
    level: deprecationLevel,
    message: (0, _i18n_texts.getApiDeprecationMessage)(deprecatedApiDetails, apiUsageStats, docLinks),
    documentationUrl: routeDeprecationOptions === null || routeDeprecationOptions === void 0 ? void 0 : routeDeprecationOptions.documentationUrl,
    correctiveActions: {
      manualSteps: (0, _i18n_texts.getApiDeprecationsManualSteps)(),
      mark_as_resolved_api: {
        routePath,
        routeMethod,
        routeVersion,
        apiTotalCalls,
        totalMarkedAsResolved,
        timestamp: new Date()
      }
    },
    deprecationType: 'api',
    domainId: 'core.http.access-deprecations'
  };
};
exports.buildApiAccessDeprecationDetails = buildApiAccessDeprecationDetails;