"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContentClient = void 0;
var _crud = require("../core/crud");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const secretToken = Symbol('secretToken');
class ContentClient {
  static create(contentTypeId, ctx) {
    return new ContentClient(secretToken, contentTypeId, ctx);
  }
  constructor(token, contentTypeId, ctx) {
    this.contentTypeId = contentTypeId;
    this.ctx = ctx;
    if (token !== secretToken) {
      throw new Error('Use ContentClient.create() instead');
    }
    if (ctx.crudInstance instanceof _crud.ContentCrud === false) {
      throw new Error('Crud instance missing or not an instance of ContentCrud');
    }
  }
  get(id, options) {
    return this.ctx.crudInstance.get(this.ctx.storageContext, id, options);
  }
  bulkGet(ids, options) {
    return this.ctx.crudInstance.bulkGet(this.ctx.storageContext, ids, options);
  }
  create(data, options) {
    return this.ctx.crudInstance.create(this.ctx.storageContext, data, options);
  }
  update(id, data, options) {
    return this.ctx.crudInstance.update(this.ctx.storageContext, id, data, options);
  }
  delete(id, options) {
    return this.ctx.crudInstance.delete(this.ctx.storageContext, id, options);
  }
  search(query, options) {
    return this.ctx.crudInstance.search(this.ctx.storageContext, query, options);
  }
}
exports.ContentClient = ContentClient;